(ns tree-form.subs
  (:require [re-frame.core :as rf]
            [tree-form.utils :as utils]))


(rf/reg-sub
  :tree-form/to-path
  (fn [db [_ path]]
    (get-in db path)))


(rf/reg-sub
  :tree-form/get-form-fields
  (fn [db [_ form]]
    (let [form-id    (:id form)
          raw-fields (get-in db [:tree-form/forms form-id :fields])]
      (utils/create-fields raw-fields form))))


(rf/reg-sub
  :tree-form/get-form-errors
  (fn [db [_ form]]
    (let [form-id (:id form)]
      (get-in db [:tree-form/forms form-id :errors]))))

