(defproject getacorn/tree-form "0.1.1"

  :description "Helpers and components to deal with forms"

  :url "https://github.com/aludio/tree-form"

  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  :jvm-opts ["--add-modules" "java.xml.bind"]

  :min-lein-version "2.8.1"

  :plugins [[lein-cljsbuild "1.1.7" :exclusions [[org.clojure/clojure]]]]

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.10.339"]
                 [reagent "0.8.0"]
                 [re-frame "0.10.5"]]

  :profiles {:dev
             {:dependencies   [[devcards "0.2.5"]
                               [figwheel-sidecar "0.5.16"]
                               [com.cemerick/piggieback "0.2.1"]
                               [binaryage/devtools "0.9.10"]]
              :plugins        [[lein-figwheel "0.5.16"]]
              :resource-paths ["resources"]}}

  :source-paths ["src"]

  :figwheel {:nrepl-port 7999}

  :cljsbuild {:builds
              [{:id           "devcards"
                :source-paths ["src" "dev" "devcards"]
                :figwheel     {:devcards  true
                               :open-urls ["http://localhost:3449/index.html"]}

                :compiler     {:main                 "tree-form.cards"
                               :asset-path           "js/compiled/out"
                               :output-to            "resources/public/js/compiled/main.js"
                               :output-dir           "resources/public/js/compiled/out"
                               :recompile-dependents false
                               :preloads             [devtools.preload]
                               :optimizations        :none
                               :source-map-timestamp true}}]})
