// Compiled by ClojureScript 1.10.339 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_22968 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__22969 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__22970 = null;
var count__22971 = (0);
var i__22972 = (0);
while(true){
if((i__22972 < count__22971)){
var vec__22973 = cljs.core._nth.call(null,chunk__22970,i__22972);
var effect_key = cljs.core.nth.call(null,vec__22973,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22973,(1),null);
var temp__5455__auto___22989 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___22989)){
var effect_fn_22990 = temp__5455__auto___22989;
effect_fn_22990.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__22991 = seq__22969;
var G__22992 = chunk__22970;
var G__22993 = count__22971;
var G__22994 = (i__22972 + (1));
seq__22969 = G__22991;
chunk__22970 = G__22992;
count__22971 = G__22993;
i__22972 = G__22994;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22969);
if(temp__5457__auto__){
var seq__22969__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22969__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__22969__$1);
var G__22995 = cljs.core.chunk_rest.call(null,seq__22969__$1);
var G__22996 = c__4351__auto__;
var G__22997 = cljs.core.count.call(null,c__4351__auto__);
var G__22998 = (0);
seq__22969 = G__22995;
chunk__22970 = G__22996;
count__22971 = G__22997;
i__22972 = G__22998;
continue;
} else {
var vec__22976 = cljs.core.first.call(null,seq__22969__$1);
var effect_key = cljs.core.nth.call(null,vec__22976,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22976,(1),null);
var temp__5455__auto___22999 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___22999)){
var effect_fn_23000 = temp__5455__auto___22999;
effect_fn_23000.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__23001 = cljs.core.next.call(null,seq__22969__$1);
var G__23002 = null;
var G__23003 = (0);
var G__23004 = (0);
seq__22969 = G__23001;
chunk__22970 = G__23002;
count__22971 = G__23003;
i__22972 = G__23004;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__22808__auto___23005 = re_frame.interop.now.call(null);
var duration__22809__auto___23006 = (end__22808__auto___23005 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__22809__auto___23006,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__22808__auto___23005);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_22968;
}} else {
var seq__22979 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__22980 = null;
var count__22981 = (0);
var i__22982 = (0);
while(true){
if((i__22982 < count__22981)){
var vec__22983 = cljs.core._nth.call(null,chunk__22980,i__22982);
var effect_key = cljs.core.nth.call(null,vec__22983,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22983,(1),null);
var temp__5455__auto___23007 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___23007)){
var effect_fn_23008 = temp__5455__auto___23007;
effect_fn_23008.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__23009 = seq__22979;
var G__23010 = chunk__22980;
var G__23011 = count__22981;
var G__23012 = (i__22982 + (1));
seq__22979 = G__23009;
chunk__22980 = G__23010;
count__22981 = G__23011;
i__22982 = G__23012;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22979);
if(temp__5457__auto__){
var seq__22979__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22979__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__22979__$1);
var G__23013 = cljs.core.chunk_rest.call(null,seq__22979__$1);
var G__23014 = c__4351__auto__;
var G__23015 = cljs.core.count.call(null,c__4351__auto__);
var G__23016 = (0);
seq__22979 = G__23013;
chunk__22980 = G__23014;
count__22981 = G__23015;
i__22982 = G__23016;
continue;
} else {
var vec__22986 = cljs.core.first.call(null,seq__22979__$1);
var effect_key = cljs.core.nth.call(null,vec__22986,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22986,(1),null);
var temp__5455__auto___23017 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___23017)){
var effect_fn_23018 = temp__5455__auto___23017;
effect_fn_23018.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__23019 = cljs.core.next.call(null,seq__22979__$1);
var G__23020 = null;
var G__23021 = (0);
var G__23022 = (0);
seq__22979 = G__23019;
chunk__22980 = G__23020;
count__22981 = G__23021;
i__22982 = G__23022;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__23023 = cljs.core.seq.call(null,value);
var chunk__23024 = null;
var count__23025 = (0);
var i__23026 = (0);
while(true){
if((i__23026 < count__23025)){
var map__23027 = cljs.core._nth.call(null,chunk__23024,i__23026);
var map__23027__$1 = ((((!((map__23027 == null)))?(((((map__23027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23027.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23027):map__23027);
var effect = map__23027__$1;
var ms = cljs.core.get.call(null,map__23027__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__23027__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__23023,chunk__23024,count__23025,i__23026,map__23027,map__23027__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__23023,chunk__23024,count__23025,i__23026,map__23027,map__23027__$1,effect,ms,dispatch))
,ms);
}


var G__23031 = seq__23023;
var G__23032 = chunk__23024;
var G__23033 = count__23025;
var G__23034 = (i__23026 + (1));
seq__23023 = G__23031;
chunk__23024 = G__23032;
count__23025 = G__23033;
i__23026 = G__23034;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23023);
if(temp__5457__auto__){
var seq__23023__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23023__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__23023__$1);
var G__23035 = cljs.core.chunk_rest.call(null,seq__23023__$1);
var G__23036 = c__4351__auto__;
var G__23037 = cljs.core.count.call(null,c__4351__auto__);
var G__23038 = (0);
seq__23023 = G__23035;
chunk__23024 = G__23036;
count__23025 = G__23037;
i__23026 = G__23038;
continue;
} else {
var map__23029 = cljs.core.first.call(null,seq__23023__$1);
var map__23029__$1 = ((((!((map__23029 == null)))?(((((map__23029.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23029.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23029):map__23029);
var effect = map__23029__$1;
var ms = cljs.core.get.call(null,map__23029__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__23029__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__23023,chunk__23024,count__23025,i__23026,map__23029,map__23029__$1,effect,ms,dispatch,seq__23023__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__23023,chunk__23024,count__23025,i__23026,map__23029,map__23029__$1,effect,ms,dispatch,seq__23023__$1,temp__5457__auto__))
,ms);
}


var G__23039 = cljs.core.next.call(null,seq__23023__$1);
var G__23040 = null;
var G__23041 = (0);
var G__23042 = (0);
seq__23023 = G__23039;
chunk__23024 = G__23040;
count__23025 = G__23041;
i__23026 = G__23042;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__23043 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__23044 = null;
var count__23045 = (0);
var i__23046 = (0);
while(true){
if((i__23046 < count__23045)){
var event = cljs.core._nth.call(null,chunk__23044,i__23046);
re_frame.router.dispatch.call(null,event);


var G__23047 = seq__23043;
var G__23048 = chunk__23044;
var G__23049 = count__23045;
var G__23050 = (i__23046 + (1));
seq__23043 = G__23047;
chunk__23044 = G__23048;
count__23045 = G__23049;
i__23046 = G__23050;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23043);
if(temp__5457__auto__){
var seq__23043__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23043__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__23043__$1);
var G__23051 = cljs.core.chunk_rest.call(null,seq__23043__$1);
var G__23052 = c__4351__auto__;
var G__23053 = cljs.core.count.call(null,c__4351__auto__);
var G__23054 = (0);
seq__23043 = G__23051;
chunk__23044 = G__23052;
count__23045 = G__23053;
i__23046 = G__23054;
continue;
} else {
var event = cljs.core.first.call(null,seq__23043__$1);
re_frame.router.dispatch.call(null,event);


var G__23055 = cljs.core.next.call(null,seq__23043__$1);
var G__23056 = null;
var G__23057 = (0);
var G__23058 = (0);
seq__23043 = G__23055;
chunk__23044 = G__23056;
count__23045 = G__23057;
i__23046 = G__23058;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__23059 = cljs.core.seq.call(null,value);
var chunk__23060 = null;
var count__23061 = (0);
var i__23062 = (0);
while(true){
if((i__23062 < count__23061)){
var event = cljs.core._nth.call(null,chunk__23060,i__23062);
clear_event.call(null,event);


var G__23063 = seq__23059;
var G__23064 = chunk__23060;
var G__23065 = count__23061;
var G__23066 = (i__23062 + (1));
seq__23059 = G__23063;
chunk__23060 = G__23064;
count__23061 = G__23065;
i__23062 = G__23066;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23059);
if(temp__5457__auto__){
var seq__23059__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23059__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__23059__$1);
var G__23067 = cljs.core.chunk_rest.call(null,seq__23059__$1);
var G__23068 = c__4351__auto__;
var G__23069 = cljs.core.count.call(null,c__4351__auto__);
var G__23070 = (0);
seq__23059 = G__23067;
chunk__23060 = G__23068;
count__23061 = G__23069;
i__23062 = G__23070;
continue;
} else {
var event = cljs.core.first.call(null,seq__23059__$1);
clear_event.call(null,event);


var G__23071 = cljs.core.next.call(null,seq__23059__$1);
var G__23072 = null;
var G__23073 = (0);
var G__23074 = (0);
seq__23059 = G__23071;
chunk__23060 = G__23072;
count__23061 = G__23073;
i__23062 = G__23074;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1540478166902
