// Compiled by ClojureScript 1.10.339 {}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.call(null,(0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_.call(null,re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.call(null,(0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation.");
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.call(null,re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__22830){
var map__22831 = p__22830;
var map__22831__$1 = ((((!((map__22831 == null)))?(((((map__22831.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22831.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22831):map__22831);
var operation = cljs.core.get.call(null,map__22831__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.call(null,map__22831__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.call(null,map__22831__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.call(null,map__22831__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id.call(null),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now.call(null)], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce.call(null,(function re_frame$trace$tracing_cb_debounced(){
var seq__22833_22845 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__22834_22846 = null;
var count__22835_22847 = (0);
var i__22836_22848 = (0);
while(true){
if((i__22836_22848 < count__22835_22847)){
var vec__22837_22849 = cljs.core._nth.call(null,chunk__22834_22846,i__22836_22848);
var k_22850 = cljs.core.nth.call(null,vec__22837_22849,(0),null);
var cb_22851 = cljs.core.nth.call(null,vec__22837_22849,(1),null);
try{cb_22851.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e22840){var e_22852 = e22840;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_22850,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_22852);
}

var G__22853 = seq__22833_22845;
var G__22854 = chunk__22834_22846;
var G__22855 = count__22835_22847;
var G__22856 = (i__22836_22848 + (1));
seq__22833_22845 = G__22853;
chunk__22834_22846 = G__22854;
count__22835_22847 = G__22855;
i__22836_22848 = G__22856;
continue;
} else {
var temp__5457__auto___22857 = cljs.core.seq.call(null,seq__22833_22845);
if(temp__5457__auto___22857){
var seq__22833_22858__$1 = temp__5457__auto___22857;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22833_22858__$1)){
var c__4351__auto___22859 = cljs.core.chunk_first.call(null,seq__22833_22858__$1);
var G__22860 = cljs.core.chunk_rest.call(null,seq__22833_22858__$1);
var G__22861 = c__4351__auto___22859;
var G__22862 = cljs.core.count.call(null,c__4351__auto___22859);
var G__22863 = (0);
seq__22833_22845 = G__22860;
chunk__22834_22846 = G__22861;
count__22835_22847 = G__22862;
i__22836_22848 = G__22863;
continue;
} else {
var vec__22841_22864 = cljs.core.first.call(null,seq__22833_22858__$1);
var k_22865 = cljs.core.nth.call(null,vec__22841_22864,(0),null);
var cb_22866 = cljs.core.nth.call(null,vec__22841_22864,(1),null);
try{cb_22866.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e22844){var e_22867 = e22844;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_22865,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_22867);
}

var G__22868 = cljs.core.next.call(null,seq__22833_22858__$1);
var G__22869 = null;
var G__22870 = (0);
var G__22871 = (0);
seq__22833_22845 = G__22868;
chunk__22834_22846 = G__22869;
count__22835_22847 = G__22870;
i__22836_22848 = G__22871;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref.call(null,re_frame.trace.next_delivery) - (10)) < now)){
re_frame.trace.schedule_debounce.call(null);

return cljs.core.reset_BANG_.call(null,re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=trace.js.map?rel=1540478166299
