(ns tree-form.cards
  (:require [devcards.core]
            [re-frame.db :refer [app-db]]
            [tree-form.core :refer [form]]
            [tree-form.forms :as f])
  (:require-macros [devcards.core :as dc :refer [defcard defcard-doc]]))


(enable-console-print!)

(defcard
  "# tree-form

  ### Component to deal with forms in re-frame/reagent stack.")


(defcard-doc
  "### Usage

  ```clojure
  (ns my.super-ns
    (:require [tree-form.core :refer [form]]))

  (defn form-component-example []
    [form {:id          :my-super-form ;; should be a uniq key
           :validate    my-validate-fn
           :on-submit   my-submit-fn
           :init        my-init-fn
           :clean-up    my-clean-up-fn
           :clear-state false
           :fields      {:my-something nil
                         :my-name      {:default \"Albert\"}
                         :my-age       {:default 10
                                        :validate validate-field-fn
                                        :validate-on-action true
                                        :process (comp js/parseInt #($ % :target.value))}}
           :includes    {:my-custon-prop-name [:path :to :prop :in :db]}}

     (fn [{:keys [fields errors includes on-submit]}]
       [:form {:on-submit on-submit}
        [:input {:on-change (-> fields :my-name :action)
                 :value     (-> fields :my-name :value)}]])])
  ```
  ")


(defcard
  basic-usage
  (dc/reagent f/basic-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})


(defcard
  form-with-validation
  (dc/reagent f/validate-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  form-with-submit-handler
  (dc/reagent f/submit-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  form-with-init-handler
  (dc/reagent f/init-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  form-with-clean-up-handler
  (dc/reagent f/clean-up-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  do-not-clear-state-form
  (dc/reagent f/do-not-clear-state-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  form-with-default-values
  (dc/reagent f/default-values-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  process-field-form
  (dc/reagent f/process-field-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  validate-individual-fields
  (dc/reagent f/validate-individual-fields-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  validate-individual-fields-on-demand
  (dc/reagent f/validate-on-demand-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

(defcard
  form-with-additional-values-from-state
  (dc/reagent f/additional-values-from-state-form-example)
  app-db
  {:inspect-data true
   :frame        true
   :history      true})

