// Compiled by ClojureScript 1.10.339 {}
goog.provide('tree_form.components');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('reagent.interop');
goog.require('re_frame.core');
goog.require('tree_form.utils');
/**
 * Basic usage:
 * 
 *   [form {:id          :my-super-form
 *       :validate    my-validate-fn
 *       :on-submit   my-submit-fn
 *       :init        my-init-fn
 *       :clean-up    my-clean-up-fn
 *       :clear-state false
 *       :fields      {:my-something nil
 *                     :my-name      {:default "Albert"}
 *                     :my-age       {:default 10
 *                                    :validate validate-field-fn
 *                                    :validate-on-action true
 *                                    :process (comp js/parseInt #($ % :target.value))}}
 *       :includes    {:my-custon-prop-name [:path :to :prop :in :db]}}
 * 
 *  (fn [{:keys [fields errors includes on-submit]}]
 *    [:form {:on-submit on-submit}
 *     [:input {:on-change (-> fields :my-name :action)
 *              :value (-> fields :my-name :value)}]])]
 *   
 */
tree_form.components.form = (function tree_form$components$form(p__22383){
var map__22384 = p__22383;
var map__22384__$1 = ((((!((map__22384 == null)))?(((((map__22384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22384.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22384):map__22384);
var form_props = map__22384__$1;
var includes = cljs.core.get.call(null,map__22384__$1,new cljs.core.Keyword(null,"includes","includes",-438304563));
var form_fields = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","get-form-fields","tree-form/get-form-fields",853086108),form_props], null));
var form_errors = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","get-form-errors","tree-form/get-form-errors",952352069),form_props], null));
var form_includes = tree_form.utils.create_subscriptions.call(null,includes);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"tree-form",new cljs.core.Keyword(null,"component-will-mount","component-will-mount",209708855),((function (form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","create-new-form","tree-form/create-new-form",1057844166),form_props], null));
});})(form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes))
,new cljs.core.Keyword(null,"component-will-unmount","component-will-unmount",-2058314698),((function (form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes){
return (function (this$){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","clean-up","tree-form/clean-up",-440053722),reagent.core.props.call(null,this$)], null));
});})(form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes))
,new cljs.core.Keyword(null,"render","render",-1408033454),((function (form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes){
return (function (this$){
var fields = cljs.core.deref.call(null,form_fields);
var errors = cljs.core.deref.call(null,form_errors);
var ui_fn = cljs.core.first.call(null,reagent.core.children.call(null,this$));
var submit_fn = ((function (fields,errors,ui_fn,form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes){
return (function (event){
(event["preventDefault"])();

return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","submit","tree-form/submit",-31566694),reagent.core.props.call(null,this$)], null));
});})(fields,errors,ui_fn,form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes))
;
var includes__$1 = tree_form.utils.deref_subscriptions.call(null,form_includes);
return ui_fn.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fields","fields",-1932066230),fields,new cljs.core.Keyword(null,"errors","errors",-908790718),errors,new cljs.core.Keyword(null,"includes","includes",-438304563),includes__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),submit_fn], null));
});})(form_fields,form_errors,form_includes,map__22384,map__22384__$1,form_props,includes))
], null));
});

//# sourceMappingURL=components.js.map?rel=1541107889808
