(ns leiningen.new.gitlab-lib
  "Generate a library project with Gitlab-specific config."
  (:require [leiningen.core.main :as main]
            [leiningen.new.templates
             :refer
             [->files
              date
              group-name
              multi-segment
              name-to-path
              project-name
              renderer
              sanitize-ns
              year]]))

(def render (renderer "gitlab-lib"))

(defn gitlab-lib
  "A leiningen template for a Clojure library hosted on gitlab.com

  It initializes support for doc pages, CI and CD to Clojars.

  **Requires** a group id in the project name: `lein new vise890/baz`

  ;; FIXME group id doesn't support dots!
  "
  [name]
  (let [main-ns (multi-segment (sanitize-ns name))
        data    {:raw-name    name
                 :name        (project-name name)
                 :group       (group-name name)
                 :main-ns     main-ns
                 :nested-dirs (name-to-path main-ns)
                 :year        (year)
                 :date        (date)}]
    (main/info "Generating a project called" name "based on the 'gitlab-lib' template.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             [".gitlab-ci.yml" (render "gitlab-ci.yml" data)]
             ["src/{{nested-dirs}}.clj" (render "core.clj" data)]
             ["test/{{nested-dirs}}_test.clj" (render "test.clj" data)]
             ["LICENSE" (render "LICENSE" data)]
             "resources")
    (main/info "You *must* setup the Clojars username and password on Gitlab for CD to work (secret env variables `LEIN_USERNAME` and `LEIN_PASSWORD`).")))
