package storm.kafka;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class ClojureSpoutConfig extends SpoutConfig {

    public ClojureSpoutConfig(final List<HostPort> hosts, final int partitionsPerHost, final String topic, final String zkRoot, final String id, final List<String> streamIds) {
        super(hosts, partitionsPerHost, topic, zkRoot, id, streamIds);
    }

    public static ClojureSpoutConfig fromString(String hostportswithroot, int partitionsPerHost, String topic, String id, List<String> streamIds) {
        String[] parts = hostportswithroot.split("/$", 2);
        String hostports = KafkaConfig.rstrip(parts[0], '/');
        String zkRoot = "";
        if (parts.length>1)
            zkRoot = parts[1].trim();
        return new ClojureSpoutConfig(KafkaConfig.convertHosts(Arrays.asList(hostports)), partitionsPerHost, topic, zkRoot, id, streamIds);
    }
}
