package storm.kafka;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;


public class SpoutConfig extends KafkaConfig implements Serializable {
    public List<String> zkServers = null;
    public Integer zkPort = null;
    public String zkRoot = null;
    public String id = null;
    public long stateUpdateIntervalMs = 2000;
    public final List<String> streamIds;

    public SpoutConfig(List<HostPort> hosts, int partitionsPerHost, String topic, String zkRoot, String id) {
        super(hosts, partitionsPerHost, topic);
        this.zkRoot = zkRoot;
        this.id = id;
        this.streamIds = new ArrayList<String>();
    }

    public SpoutConfig(List<HostPort> hosts, int partitionsPerHost, String topic, String zkRoot, String id, List<String> streamIds) {
        super(hosts, partitionsPerHost, topic);
        this.zkRoot = zkRoot;
        this.id = id;
        this.streamIds = streamIds;
    }

    public static SpoutConfig fromHostStrings(List<String> hosts, int partitionsPerHost, String topic, String zkRoot, String id) {
        return new SpoutConfig(KafkaConfig.convertHosts(hosts), partitionsPerHost, topic, zkRoot, id);
    }
}
