package storm.kafka;

import java.util.List;

public class ClojureSpoutConfig extends SpoutConfig {
    public ClojureSpoutConfig(final List<HostPort> hosts, final int partitionsPerHost, final String topic, final String zkRoot, final String id, final List<String> streamIds) {
        super(hosts, partitionsPerHost, topic, zkRoot, id, streamIds);
    }

    public static ClojureSpoutConfig fromString(List<String> hostports, int partitionsPerHost, String topic, String zkRoot, String id, List<String> streamIds) {
        return new ClojureSpoutConfig(KafkaConfig.convertHosts(hostports), partitionsPerHost, topic, zkRoot, id, streamIds);
    }
}
