(def VERSION (.trim (slurp "VERSION")))

(defproject gorillalabs/specter VERSION
  :jvm-opts ["-XX:-OmitStackTraceInFastThrow"] ; this prevents JVM from doing optimizations which can remove stack traces from NPE and other exceptions
             ;"-agentpath:/Applications/YourKit_Java_Profiler_2015_build_15056.app/Contents/Resources/bin/mac/libyjpagent.jnilib"]

  :source-paths ["src/clj"]
  :java-source-paths ["src/java"]
  :test-paths ["test", "target/test-classes"]
  :auto-clean false
  :dependencies [[riddley "0.1.12"]]
  :plugins [[lein-codox "0.9.5"]]
  :codox {:source-paths ["target/classes" "src/clj"]
          :namespaces [com.rpl.specter
                       com.rpl.specter.zipper
                       com.rpl.specter.protocols
                       com.rpl.specter.transients]
          :source-uri
            {#"target/classes" "https://github.com/nathanmarz/specter/tree/{version}/src/clj/{classpath}x#L{line}"
             #".*"             "https://github.com/nathanmarz/specter/tree/{version}/src/clj/{classpath}#L{line}"}}

  :repositories [["releases" {:url   "http://172.18.101.210/repository/CYPP/" :creds :gpg}]]
  :deploy-repositories [["releases" {:url   "http://172.18.101.210/repository/CYPP-builds/"
                                     :creds :gpg}]
                        ["snapshots" {:url   "http://172.18.101.210/repository/CYPP-build-snapshots/"
                                      :creds :gpg}]]         ;; make sure you have your ~/.lein/credentials.clj.gpg setup correctly

  :profiles {:dev {:dependencies
                   [[org.clojure/test.check "0.7.0"]
                    [org.clojure/clojure "1.7.0"]
                    [org.clojure/clojurescript "1.7.122"]]}

             :test {:dependencies [[org.clojure/clojure "1.7.0"]]}}

  :aliases {"deploy" ["do" "clean," "deploy" "clojars"]})
