/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.KeyColumnValueStoreTest;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.testcategory.OrderedKeyStoreTests;
import com.thinkaurelius.titan.testcategory.UnorderedKeyStoreTests;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraStoreTest
extends KeyColumnValueStoreTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractCassandraStoreTest.class);
    private static final String TEST_CF_NAME = "testcf";
    private static final String DEFAULT_COMPRESSOR_PACKAGE = "org.apache.cassandra.io.compress";

    public abstract ModifiableConfiguration getBaseStorageConfiguration();

    public abstract AbstractCassandraStoreManager openStorageManager(Configuration var1) throws BackendException;

    @Test
    @Category(value={UnorderedKeyStoreTests.class})
    public void testUnorderedConfiguration() {
        if (!this.manager.getFeatures().hasUnorderedScan()) {
            log.warn("Can't test key-unordered features on incompatible store.  This warning could indicate reduced test coverage and a broken JUnit configuration.  Skipping test {}.", (Object)this.name.getMethodName());
            return;
        }
        StoreFeatures features = this.manager.getFeatures();
        Assert.assertFalse((boolean)features.isKeyOrdered());
        Assert.assertFalse((boolean)features.hasLocalKeyPartition());
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testOrderedConfiguration() {
        if (!this.manager.getFeatures().hasOrderedScan()) {
            log.warn("Can't test key-ordered features on incompatible store.  This warning could indicate reduced test coverage and a broken JUnit configuration.  Skipping test {}.", (Object)this.name.getMethodName());
            return;
        }
        StoreFeatures features = this.manager.getFeatures();
        Assert.assertTrue((boolean)features.isKeyOrdered());
    }

    @Test
    public void testDefaultCFCompressor() throws BackendException {
        String cf = "testcf_snappy";
        AbstractCassandraStoreManager mgr = this.openStorageManager();
        mgr.openDatabase("testcf_snappy");
        ImmutableMap defaultCfCompressionOps = new ImmutableMap.Builder().put((Object)"sstable_compression", (Object)("org.apache.cassandra.io.compress." + (String)AbstractCassandraStoreManager.CF_COMPRESSION_TYPE.getDefaultValue())).put((Object)"chunk_length_kb", (Object)"64").build();
        Assert.assertEquals((Object)defaultCfCompressionOps, (Object)mgr.getCompressionOptions("testcf_snappy"));
    }

    @Test
    public void testCustomCFCompressor() throws BackendException {
        String cname = "DeflateCompressor";
        int ckb = 128;
        String cf = "testcf_gzip";
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(AbstractCassandraStoreManager.CF_COMPRESSION_TYPE, (Object)"DeflateCompressor", new String[0]);
        config.set(AbstractCassandraStoreManager.CF_COMPRESSION_BLOCK_SIZE, (Object)128, new String[0]);
        AbstractCassandraStoreManager mgr = this.openStorageManager((Configuration)config);
        mgr.openDatabase("testcf_gzip");
        ImmutableMap expected = ImmutableMap.builder().put((Object)"sstable_compression", (Object)"org.apache.cassandra.io.compress.DeflateCompressor").put((Object)"chunk_length_kb", (Object)String.valueOf(128)).build();
        Assert.assertEquals((Object)expected, (Object)mgr.getCompressionOptions("testcf_gzip"));
    }

    @Test
    public void testDisableCFCompressor() throws BackendException {
        String cf = "testcf_nocompress";
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(AbstractCassandraStoreManager.CF_COMPRESSION, (Object)false, new String[0]);
        AbstractCassandraStoreManager mgr = this.openStorageManager((Configuration)config);
        mgr.openDatabase("testcf_nocompress");
        Assert.assertEquals(Collections.emptyMap(), (Object)mgr.getCompressionOptions("testcf_nocompress"));
    }

    @Test
    public void testTTLSupported() throws Exception {
        StoreFeatures features = this.manager.getFeatures();
        Assert.assertTrue((boolean)features.hasCellTTL());
    }

    public AbstractCassandraStoreManager openStorageManager() throws BackendException {
        return this.openStorageManager((Configuration)this.getBaseStorageConfiguration());
    }
}

