/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.thinkaurelius.titan.testcategory.StandaloneTests;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={StandaloneTests.class})
public class UUIDTest {
    public static final String z = "00000000-0000-1000-0000-000000000000";
    public static final String v = "9451e273-7753-11e0-92df-e700f669bcfc";

    @Test
    public void timeUUIDComparison() {
        TimeUUIDType ti = TimeUUIDType.instance;
        UUID zu = UUID.fromString(z);
        UUID vu = UUID.fromString(v);
        ByteBuffer zb = ti.decompose((Object)zu);
        ByteBuffer vb = ti.decompose((Object)vu);
        Assert.assertEquals((long)-1L, (long)ti.compare(zb, vb));
        Assert.assertEquals((long)1L, (long)zu.compareTo(vu));
        Assert.assertEquals((long)1L, (long)ti.compare(vb, zb));
        Assert.assertEquals((long)-1L, (long)vu.compareTo(zu));
    }
}

