/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CLevel;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTransaction
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(CassandraTransaction.class);
    private final CLevel read = CLevel.parse((String)this.getConfiguration().getCustomOption(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY));
    private final CLevel write = CLevel.parse((String)this.getConfiguration().getCustomOption(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY));

    public CassandraTransaction(BaseTransactionConfig c) {
        super(c);
        log.debug("Created {}", (Object)this.toString());
    }

    public CLevel getReadConsistencyLevel() {
        return this.read;
    }

    public CLevel getWriteConsistencyLevel() {
        return this.write;
    }

    public static CassandraTransaction getTx(StoreTransaction txh) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(txh instanceof CassandraTransaction), (String)"Unexpected transaction type %s", (Object[])new Object[]{txh.getClass().getName()});
        return (CassandraTransaction)txh;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("CassandraTransaction@");
        sb.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        sb.append("[read=");
        sb.append(this.read);
        sb.append(",write=");
        sb.append(this.write);
        sb.append("]");
        return sb.toString();
    }
}

