/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.common;

import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.ArrayList;

public abstract class AbstractStoreManager
implements StoreManager {
    protected final boolean transactional;
    protected final boolean batchLoading;
    protected final Configuration storageConfig;

    public AbstractStoreManager(Configuration storageConfig) {
        this.batchLoading = storageConfig.get(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]);
        boolean transactional = storageConfig.get(GraphDatabaseConfiguration.STORAGE_TRANSACTIONAL, new String[0]);
        if (this.batchLoading) {
            transactional = false;
        }
        this.transactional = transactional;
        this.storageConfig = storageConfig;
    }

    public Configuration getStorageConfig() {
        return this.storageConfig;
    }

    public EntryMetaData[] getMetaDataSchema(String storeName) {
        ArrayList schemaBuilder = Lists.newArrayList();
        StoreFeatures features = this.getFeatures();
        if (features.hasTimestamps() && this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, storeName).booleanValue()) {
            schemaBuilder.add(EntryMetaData.TIMESTAMP);
        }
        if (features.hasCellTTL() && this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_TTL, storeName).booleanValue()) {
            schemaBuilder.add(EntryMetaData.TTL);
        }
        if (features.hasVisibility() && this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_VISIBILITY, storeName).booleanValue()) {
            schemaBuilder.add(EntryMetaData.VISIBILITY);
        }
        if (schemaBuilder.isEmpty()) {
            return StaticArrayEntry.EMPTY_SCHEMA;
        }
        return schemaBuilder.toArray(new EntryMetaData[schemaBuilder.size()]);
    }
}

