/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.ttl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.MetaAnnotatable;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StoreMetaData;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSManagerProxy;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ttl.TTLKCVS;
import java.util.Collection;
import java.util.Map;

public class TTLKCVSManager
extends KCVSManagerProxy {
    private final StoreFeatures features;
    private final Map<String, Integer> ttlEnabledStores = Maps.newConcurrentMap();

    public TTLKCVSManager(KeyColumnValueStoreManager manager) {
        super(manager);
        Preconditions.checkArgument((boolean)manager.getFeatures().hasCellTTL());
        Preconditions.checkArgument((!manager.getFeatures().hasStoreTTL() ? 1 : 0) != 0, (String)"Using TTLKCVSManager with %s is redundant: underlying implementation already supports store-level ttl", (Object[])new Object[]{manager});
        this.features = new StandardStoreFeatures.Builder(manager.getFeatures()).storeTTL(true).build();
    }

    public static boolean supportsAnyTTL(StoreFeatures features) {
        return features.hasCellTTL() || features.hasStoreTTL();
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.features;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name) throws BackendException {
        return this.openDatabase(name, StoreMetaData.EMPTY);
    }

    @Override
    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        KeyColumnValueStore store = this.manager.openDatabase(name);
        int storeTTL = -1;
        if (metaData.contains(StoreMetaData.TTL)) {
            storeTTL = (Integer)metaData.get(StoreMetaData.TTL);
        }
        Preconditions.checkArgument((storeTTL > 0 ? 1 : 0) != 0, (String)"TTL must be positive: %s", (Object[])new Object[]{storeTTL});
        this.ttlEnabledStores.put(name, storeTTL);
        return new TTLKCVS(store, storeTTL);
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        if (!this.manager.getFeatures().hasStoreTTL()) {
            assert (this.manager.getFeatures().hasCellTTL());
            for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> sentry : mutations.entrySet()) {
                Integer ttl = this.ttlEnabledStores.get(sentry.getKey());
                if (null == ttl || 0 >= ttl) continue;
                for (KCVMutation mut : sentry.getValue().values()) {
                    if (!mut.hasAdditions()) continue;
                    TTLKCVSManager.applyTTL(mut.getAdditions(), ttl);
                }
            }
        }
        this.manager.mutateMany(mutations, txh);
    }

    public static void applyTTL(Collection<Entry> additions, int ttl) {
        for (Entry entry : additions) {
            assert (entry instanceof MetaAnnotatable);
            ((MetaAnnotatable)((Object)entry)).setMetaData(EntryMetaData.TTL, ttl);
        }
    }
}

