/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.IntegerSerializer;

public class EnumSerializer<E extends Enum>
implements OrderPreservingSerializer<E> {
    private static final long serialVersionUID = 117423419862504186L;
    private final Class<E> datatype;
    private final IntegerSerializer ints = new IntegerSerializer();

    public EnumSerializer(Class<E> datatype) {
        Preconditions.checkArgument((datatype != null && datatype.isEnum() ? 1 : 0) != 0);
        this.datatype = datatype;
    }

    private E getValue(long ordinal) {
        Enum[] values = (Enum[])this.datatype.getEnumConstants();
        Preconditions.checkArgument((ordinal >= 0L && ordinal < (long)values.length ? 1 : 0) != 0, (String)"Invalid ordinal number (max %s): %s", (Object[])new Object[]{values.length, ordinal});
        return (E)values[(int)ordinal];
    }

    @Override
    public E read(ScanBuffer buffer) {
        return this.getValue(VariableLong.readPositive(buffer));
    }

    @Override
    public void write(WriteBuffer out, E object) {
        VariableLong.writePositive(out, ((Enum)object).ordinal());
    }

    @Override
    public E readByteOrder(ScanBuffer buffer) {
        return this.getValue(this.ints.readByteOrder(buffer).intValue());
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, E attribute) {
        this.ints.writeByteOrder(buffer, ((Enum)attribute).ordinal());
    }
}

