/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idhandling;

import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class IDHandler {
    public static final StaticBuffer MIN_KEY = BufferUtil.getLongBuffer(0L);
    public static final StaticBuffer MAX_KEY = BufferUtil.getLongBuffer(-1L);
    private static final int PREFIX_BIT_LEN = 3;

    public static int relationTypeLength(long relationTypeId) {
        assert (relationTypeId > 0L && relationTypeId << 1 > 0L);
        return VariableLong.positiveWithPrefixLength(IDManager.stripEntireRelationTypePadding(relationTypeId) << 1, 3);
    }

    public static void writeRelationType(WriteBuffer out, long relationTypeId, DirectionID dirID, boolean invisible) {
        assert (relationTypeId > 0L && relationTypeId << 1 > 0L);
        long strippedId = (IDManager.stripEntireRelationTypePadding(relationTypeId) << 1) + (long)dirID.getDirectionInt();
        VariableLong.writePositiveWithPrefix(out, strippedId, dirID.getPrefix(invisible, IDManager.isSystemRelationTypeId(relationTypeId)), 3);
    }

    public static StaticBuffer getRelationType(long relationTypeId, DirectionID dirID, boolean invisible) {
        WriteByteBuffer b = new WriteByteBuffer(IDHandler.relationTypeLength(relationTypeId));
        IDHandler.writeRelationType(b, relationTypeId, dirID, invisible);
        return b.getStaticBuffer();
    }

    public static RelationTypeParse readRelationType(ReadBuffer in) {
        boolean isSystemType;
        long[] countPrefix = VariableLong.readPositiveWithPrefix(in, 3);
        DirectionID dirID = DirectionID.getDirectionID((int)countPrefix[1] & 1, (int)(countPrefix[0] & 1L));
        long typeId = countPrefix[0] >>> 1;
        boolean bl = isSystemType = countPrefix[1] >> 1 == 0L;
        typeId = dirID == DirectionID.PROPERTY_DIR ? IDManager.getSchemaId(isSystemType ? IDManager.VertexIDType.SystemPropertyKey : IDManager.VertexIDType.UserPropertyKey, typeId) : IDManager.getSchemaId(isSystemType ? IDManager.VertexIDType.SystemEdgeLabel : IDManager.VertexIDType.UserEdgeLabel, typeId);
        return new RelationTypeParse(typeId, dirID);
    }

    public static void writeInlineRelationType(WriteBuffer out, long relationTypeId) {
        long compressId = IDManager.stripRelationTypePadding(relationTypeId);
        VariableLong.writePositive(out, compressId);
    }

    public static long readInlineRelationType(ReadBuffer in) {
        long compressId = VariableLong.readPositive(in);
        return IDManager.addRelationTypePadding(compressId);
    }

    private static StaticBuffer getPrefixed(int prefix) {
        assert (prefix < 8 && prefix >= 0);
        byte[] arr = new byte[]{(byte)(prefix << 5)};
        return new StaticArrayBuffer(arr);
    }

    public static StaticBuffer[] getBounds(RelationCategory type, boolean systemTypes) {
        int end;
        int start;
        switch (type) {
            case PROPERTY: {
                end = start = DirectionID.PROPERTY_DIR.getPrefix(systemTypes, systemTypes);
                break;
            }
            case EDGE: {
                end = start = DirectionID.EDGE_OUT_DIR.getPrefix(systemTypes, systemTypes);
                break;
            }
            case RELATION: {
                start = DirectionID.PROPERTY_DIR.getPrefix(systemTypes, systemTypes);
                end = DirectionID.EDGE_OUT_DIR.getPrefix(systemTypes, systemTypes);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized type:" + type));
            }
        }
        assert (++end > start);
        return new StaticBuffer[]{IDHandler.getPrefixed(start), IDHandler.getPrefixed(end)};
    }

    public static class RelationTypeParse {
        public final long typeId;
        public final DirectionID dirID;

        public RelationTypeParse(long typeId, DirectionID dirID) {
            this.typeId = typeId;
            this.dirID = dirID;
        }
    }

    public static final class DirectionID
    extends Enum<DirectionID> {
        public static final /* enum */ DirectionID PROPERTY_DIR = new DirectionID(0);
        public static final /* enum */ DirectionID EDGE_OUT_DIR = new DirectionID(2);
        public static final /* enum */ DirectionID EDGE_IN_DIR = new DirectionID(3);
        private final int id;
        private static final /* synthetic */ DirectionID[] $VALUES;

        public static DirectionID[] values() {
            return (DirectionID[])$VALUES.clone();
        }

        public static DirectionID valueOf(String name) {
            return Enum.valueOf(DirectionID.class, name);
        }

        private DirectionID(int id) {
            this.id = id;
        }

        private int getRelationType() {
            return this.id >>> 1;
        }

        private int getDirectionInt() {
            return this.id & 1;
        }

        public RelationCategory getRelationCategory() {
            switch (this) {
                case PROPERTY_DIR: {
                    return RelationCategory.PROPERTY;
                }
                case EDGE_IN_DIR: 
                case EDGE_OUT_DIR: {
                    return RelationCategory.EDGE;
                }
            }
            throw new AssertionError();
        }

        public Direction getDirection() {
            switch (this) {
                case PROPERTY_DIR: 
                case EDGE_OUT_DIR: {
                    return Direction.OUT;
                }
                case EDGE_IN_DIR: {
                    return Direction.IN;
                }
            }
            throw new AssertionError();
        }

        private int getPrefix(boolean invisible, boolean systemType) {
            assert (!systemType || invisible);
            return ((systemType ? 0 : (invisible ? 2 : 1)) << 1) + this.getRelationType();
        }

        private static DirectionID getDirectionID(int relationType, int direction) {
            assert (relationType >= 0 && relationType <= 1 && direction >= 0 && direction <= 1);
            return DirectionID.forId((relationType << 1) + direction);
        }

        private static DirectionID forId(int id) {
            switch (id) {
                case 0: {
                    return PROPERTY_DIR;
                }
                case 2: {
                    return EDGE_OUT_DIR;
                }
                case 3: {
                    return EDGE_IN_DIR;
                }
            }
            throw new AssertionError((Object)("Invalid id: " + id));
        }

        static {
            $VALUES = new DirectionID[]{PROPERTY_DIR, EDGE_OUT_DIR, EDGE_IN_DIR};
        }
    }
}

