/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.Callable;

public abstract class AbstractIndexStatusWatcher<R, S extends AbstractIndexStatusWatcher<R, S>>
implements Callable<R> {
    protected TitanGraph g;
    protected SchemaStatus status;
    protected Duration timeout;
    protected Duration poll;

    public AbstractIndexStatusWatcher(TitanGraph g) {
        this.g = g;
        this.status = SchemaStatus.REGISTERED;
        this.timeout = Duration.ofSeconds(60L);
        this.poll = Duration.ofMillis(500L);
    }

    protected abstract S self();

    public S status(SchemaStatus status) {
        this.status = status;
        return this.self();
    }

    public S timeout(long timeout, TemporalUnit timeoutUnit) {
        this.timeout = 0L > timeout ? null : Duration.of(timeout, timeoutUnit);
        return this.self();
    }

    public S pollInterval(long poll, TemporalUnit pollUnit) {
        Preconditions.checkArgument((0L <= poll ? 1 : 0) != 0);
        this.poll = Duration.of(poll, pollUnit);
        return this.self();
    }
}

