/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap.computer;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraElementTraversal;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanLocalQueryOptimizerStrategy;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanVertexStep;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class FulgoraUtil {
    private static final TraversalStrategies FULGORA_STRATEGIES = TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{TitanLocalQueryOptimizerStrategy.instance()});
    private static final MessageCombiner DEFAULT_COMBINER = new ThrowingCombiner();

    public static TitanVertexStep<Vertex> getReverseTitanVertexStep(MessageScope.Local<?> scope, TitanTransaction graph) {
        FulgoraElementTraversal<Vertex, Edge> result = FulgoraUtil.getReverseTraversal(scope, graph, null);
        result.asAdmin().applyStrategies();
        FulgoraUtil.verifyIncidentTraversal(result);
        return (TitanVertexStep)result.getStartStep();
    }

    public static Traversal<Vertex, Edge> getReverseElementTraversal(MessageScope.Local<?> scope, Vertex start, TitanTransaction graph) {
        return FulgoraUtil.getReverseTraversal(scope, graph, start);
    }

    private static FulgoraElementTraversal<Vertex, Edge> getReverseTraversal(MessageScope.Local<?> scope, TitanTransaction graph, @Nullable Vertex start) {
        Traversal.Admin incident = ((Traversal)scope.getIncidentTraversal().get()).asAdmin();
        FulgoraElementTraversal<Vertex, Edge> result = FulgoraElementTraversal.of(graph);
        for (Step step : incident.getSteps()) {
            result.addStep(step);
        }
        Step startStep = result.getStartStep();
        assert (startStep instanceof VertexStep);
        ((VertexStep)startStep).reverseDirection();
        if (start != null) {
            result.addStep(0, (Step)new StartStep(incident, (Object)start));
        }
        result.asAdmin().setStrategies(FULGORA_STRATEGIES);
        return result;
    }

    private static void verifyIncidentTraversal(FulgoraElementTraversal<Vertex, Edge> traversal) {
        List steps = traversal.getSteps();
        Step startStep = (Step)steps.get(0);
        Preconditions.checkArgument((startStep instanceof TitanVertexStep && TitanTraversalUtil.isEdgeReturnStep((TitanVertexStep)startStep) ? 1 : 0) != 0, (String)"Expected first step to be an edge step but found: %s", (Object[])new Object[]{startStep});
        Optional<Step> violatingStep = steps.stream().filter(s -> !(s instanceof TitanVertexStep) && !(s instanceof OrderGlobalStep) && !(s instanceof OrderLocalStep) && !(s instanceof IdentityStep) && !(s instanceof FilterStep)).findAny();
        if (violatingStep.isPresent()) {
            throw new IllegalArgumentException("Encountered unsupported step in incident traversal: " + violatingStep.get());
        }
    }

    public static <M> MessageCombiner<M> getMessageCombiner(VertexProgram<M> program) {
        return program.getMessageCombiner().orElse(DEFAULT_COMBINER);
    }

    private static class ThrowingCombiner<M>
    implements MessageCombiner<M> {
        private ThrowingCombiner() {
        }

        public M combine(M messageA, M messageB) {
            throw new IllegalArgumentException("The VertexProgram needs to define a message combiner in order to preserve memory and handle partitioned vertices");
        }
    }
}

