/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.indextype;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeUtil;
import com.thinkaurelius.titan.graphdb.types.indextype.IndexTypeWrapper;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class CompositeIndexTypeWrapper
extends IndexTypeWrapper
implements CompositeIndexType {
    IndexField[] fields = null;
    private ConsistencyModifier consistency = null;

    public CompositeIndexTypeWrapper(SchemaSource base) {
        super(base);
    }

    @Override
    public boolean isCompositeIndex() {
        return true;
    }

    @Override
    public boolean isMixedIndex() {
        return false;
    }

    @Override
    public long getID() {
        return this.base.longId();
    }

    @Override
    public SchemaStatus getStatus() {
        return this.base.getStatus();
    }

    @Override
    public IndexField[] getFieldKeys() {
        IndexField[] result = this.fields;
        if (result == null) {
            Iterable<SchemaSource.Entry> entries = this.base.getRelated(TypeDefinitionCategory.INDEX_FIELD, Direction.OUT);
            int numFields = Iterables.size(entries);
            result = new IndexField[numFields];
            for (SchemaSource.Entry entry : entries) {
                Integer value = ParameterType.INDEX_POSITION.findParameter((Parameter[])entry.getModifier(), null);
                Preconditions.checkNotNull((Object)value);
                int pos = value;
                Preconditions.checkArgument((pos >= 0 && pos < numFields ? 1 : 0) != 0, (String)"Invalid field position: %s", (Object[])new Object[]{pos});
                assert (entry.getSchemaType() instanceof PropertyKey);
                result[pos] = IndexField.of((PropertyKey)((Object)entry.getSchemaType()));
            }
            this.fields = result;
        }
        assert (result != null);
        return result;
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.fields = null;
    }

    @Override
    public Cardinality getCardinality() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.INDEX_CARDINALITY, Cardinality.class);
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        if (this.consistency == null) {
            this.consistency = TypeUtil.getConsistencyModifier(this.base);
        }
        return this.consistency;
    }
}

