/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.util;

import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.TitanEdge;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class AllEdgesIterator
implements Iterator<Edge> {
    private final Set<? extends Vertex> vertices;
    private final Iterator<? extends Vertex> vertexIter;
    private Iterator<Edge> currentEdges = Iterators.emptyIterator();
    private Edge next;

    public AllEdgesIterator(Iterator<? extends Vertex> vertexIter) {
        this.vertexIter = vertexIter;
        this.vertices = null;
        this.next = this.findNext();
    }

    public AllEdgesIterator(Set<? extends Vertex> vertices) {
        this.vertexIter = vertices.iterator();
        this.vertices = vertices;
        this.next = this.findNext();
    }

    private Edge findNext() {
        TitanEdge rel = null;
        while (rel == null) {
            if (this.currentEdges.hasNext()) {
                rel = (TitanEdge)this.currentEdges.next();
                if (this.vertices == null || this.vertices.contains(rel.vertex(Direction.IN))) continue;
                rel = null;
                continue;
            }
            if (!this.vertexIter.hasNext()) break;
            Vertex nextVertex = this.vertexIter.next();
            this.currentEdges = nextVertex.edges(Direction.OUT, new String[0]);
        }
        return rel;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Edge next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Edge current = this.next;
        this.next = this.findNext();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removals are not supported");
    }
}

