/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.common;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistributedStoreManager
extends AbstractStoreManager {
    protected final TimestampProvider times;
    private static final Logger log = LoggerFactory.getLogger(DistributedStoreManager.class);
    private static final Random random = new Random();
    protected final String[] hostnames;
    protected final int port;
    protected final Duration connectionTimeoutMS;
    protected final int pageSize;
    protected final String username;
    protected final String password;

    public DistributedStoreManager(Configuration storageConfig, int portDefault) {
        super(storageConfig);
        this.hostnames = storageConfig.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]);
        Preconditions.checkArgument((this.hostnames.length > 0 ? 1 : 0) != 0, (Object)"No hostname configured");
        this.port = storageConfig.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]) ? storageConfig.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]) : portDefault;
        this.connectionTimeoutMS = storageConfig.get(GraphDatabaseConfiguration.CONNECTION_TIMEOUT, new String[0]);
        this.pageSize = storageConfig.get(GraphDatabaseConfiguration.PAGE_SIZE, new String[0]);
        this.times = storageConfig.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
        if (storageConfig.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])) {
            this.username = storageConfig.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]);
            this.password = storageConfig.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]);
        } else {
            this.username = null;
            this.password = null;
        }
    }

    protected String getSingleHostname() {
        return this.hostnames[random.nextInt(this.hostnames.length)];
    }

    public boolean hasAuthentication() {
        return this.username != null;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public TimestampProvider getTimestampProvider() {
        return this.times;
    }

    public abstract Deployment getDeployment();

    public String toString() {
        String hn = this.getSingleHostname();
        return hn.substring(0, Math.min(hn.length(), 256)) + ":" + this.port;
    }

    protected void sleepAfterWrite(StoreTransaction txh, MaskedTimestamp mustPass) throws BackendException {
        assert (mustPass.getDeletionTime(this.times) < mustPass.getAdditionTime(this.times));
        try {
            this.times.sleepPast(mustPass.getAdditionTimeInstant(this.times));
        }
        catch (InterruptedException e) {
            throw new PermanentBackendException("Unexpected interrupt", e);
        }
    }

    public class MaskedTimestamp {
        private final Instant t;

        public MaskedTimestamp(Instant commitTime) {
            Preconditions.checkNotNull((Object)commitTime);
            this.t = commitTime;
        }

        public MaskedTimestamp(StoreTransaction txh) {
            this(txh.getConfiguration().getCommitTime());
        }

        public long getDeletionTime(TimestampProvider times) {
            return times.getTime(this.t) & 0xFFFFFFFFFFFFFFFEL;
        }

        public long getAdditionTime(TimestampProvider times) {
            return times.getTime(this.t) & 0xFFFFFFFFFFFFFFFEL | 1L;
        }

        public Instant getAdditionTimeInstant(TimestampProvider times) {
            return times.getTime(this.getAdditionTime(times));
        }
    }

    public static enum Deployment {
        REMOTE,
        LOCAL,
        EMBEDDED;

    }
}

