/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.MergedConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.StandardScannerExecutor;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;

public class StandardScanner {
    private final KeyColumnValueStoreManager manager;
    private final Set<KeyColumnValueStore> openStores;
    private final ConcurrentMap<Object, StandardScannerExecutor> runningJobs;
    private final AtomicLong jobCounter;

    public StandardScanner(KeyColumnValueStoreManager manager) {
        Preconditions.checkArgument((manager != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)manager.getFeatures().hasScan(), (String)"Provided data store does not support scans: %s", (Object[])new Object[]{manager});
        this.manager = manager;
        this.openStores = new HashSet<KeyColumnValueStore>(4);
        this.runningJobs = new ConcurrentHashMap<Object, StandardScannerExecutor>();
        this.jobCounter = new AtomicLong(0L);
    }

    public Builder build() {
        return new Builder();
    }

    public void close() throws BackendException {
        for (StandardScannerExecutor exe : this.runningJobs.values()) {
            if (exe.isCancelled() || exe.isDone()) continue;
            exe.cancel(true);
        }
        for (KeyColumnValueStore kcvs : this.openStores) {
            kcvs.close();
        }
    }

    private void addJob(Object jobId, StandardScannerExecutor executor) {
        for (Map.Entry jobs : this.runningJobs.entrySet()) {
            StandardScannerExecutor exe = (StandardScannerExecutor)jobs.getValue();
            if (!exe.isDone() && !exe.isCancelled()) continue;
            this.runningJobs.remove(jobs.getKey(), exe);
        }
        this.runningJobs.putIfAbsent(jobId, executor);
        Preconditions.checkArgument((this.runningJobs.get(jobId) == executor ? 1 : 0) != 0, (String)"Another job with the same id is already running: %s", (Object[])new Object[]{jobId});
    }

    public TitanManagement.IndexJobFuture getRunningJob(Object jobId) {
        return (TitanManagement.IndexJobFuture)this.runningJobs.get(jobId);
    }

    public class Builder {
        private static final int DEFAULT_WORKBLOCK_SIZE = 10000;
        private ScanJob job = null;
        private int numProcessingThreads = 1;
        private int workBlockSize = 10000;
        private TimestampProvider times = null;
        private Configuration graphConfiguration = Configuration.EMPTY;
        private Configuration jobConfiguration = Configuration.EMPTY;
        private String dbName = null;
        private Consumer<ScanMetrics> finishJob;
        private Object jobId;

        private Builder() {
            this.jobId = StandardScanner.this.jobCounter.incrementAndGet();
            this.finishJob = m -> {};
        }

        public Builder setNumProcessingThreads(int numThreads) {
            Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (String)"Need to specify a positive number of processing threads: %s", (Object[])new Object[]{numThreads});
            this.numProcessingThreads = numThreads;
            return this;
        }

        public Builder setWorkBlockSize(int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Need to specify a positive work block size: %s", (Object[])new Object[]{size});
            this.workBlockSize = size;
            return this;
        }

        public Builder setTimestampProvider(TimestampProvider times) {
            Preconditions.checkArgument((times != null ? 1 : 0) != 0);
            this.times = times;
            return this;
        }

        public Builder setStoreName(String name) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (String)"Invalid name: %s", (Object[])new Object[]{name});
            this.dbName = name;
            return this;
        }

        public Object getJobId() {
            return this.jobId;
        }

        public Builder setJobId(Object id) {
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (String)"Need to provide a valid id: %s", (Object[])new Object[]{id});
            this.jobId = id;
            return this;
        }

        public Builder setJob(ScanJob job) {
            Preconditions.checkArgument((job != null ? 1 : 0) != 0);
            this.job = job;
            return this;
        }

        public Builder setGraphConfiguration(Configuration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0);
            this.graphConfiguration = config;
            return this;
        }

        public Builder setJobConfiguration(Configuration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0);
            this.jobConfiguration = config;
            return this;
        }

        public Configuration getJobConfiguration() {
            return this.jobConfiguration;
        }

        public Builder setFinishJob(Consumer<ScanMetrics> finishJob) {
            Preconditions.checkArgument((finishJob != null ? 1 : 0) != 0);
            this.finishJob = finishJob;
            return this;
        }

        public TitanManagement.IndexJobFuture execute() throws BackendException {
            Preconditions.checkArgument((this.job != null ? 1 : 0) != 0, (Object)"Need to specify a job to execute");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.dbName), (Object)"Need to specify a database to execute against");
            Preconditions.checkArgument((this.times != null ? 1 : 0) != 0, (Object)"Need to configure the timestamp provider for this job");
            StandardBaseTransactionConfig.Builder txBuilder = new StandardBaseTransactionConfig.Builder();
            txBuilder.timestampProvider(this.times);
            Configuration scanConfig = StandardScanner.this.manager.getFeatures().getScanTxConfig();
            if (Configuration.EMPTY != this.graphConfiguration) {
                Configuration configuration = scanConfig = null == scanConfig ? this.graphConfiguration : new MergedConfiguration(this.graphConfiguration, scanConfig);
            }
            if (null != scanConfig) {
                txBuilder.customOptions(scanConfig);
            }
            StoreTransaction storeTx = StandardScanner.this.manager.beginTransaction(txBuilder.build());
            KeyColumnValueStore kcvs = StandardScanner.this.manager.openDatabase(this.dbName);
            StandardScanner.this.openStores.add(kcvs);
            try {
                StandardScannerExecutor executor = new StandardScannerExecutor(this.job, this.finishJob, kcvs, storeTx, StandardScanner.this.manager.getFeatures(), this.numProcessingThreads, this.workBlockSize, this.jobConfiguration, this.graphConfiguration);
                StandardScanner.this.addJob(this.jobId, executor);
                new Thread(executor).start();
                return executor;
            }
            catch (Throwable e) {
                storeTx.rollback();
                throw e;
            }
        }
    }
}

