/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log.kcvs;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.StoreMetaData;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ttl.TTLKCVSManager;
import com.thinkaurelius.titan.diskstorage.log.LogManager;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionIDRange;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardSerializer;
import com.thinkaurelius.titan.util.encoding.ConversionHelper;
import com.thinkaurelius.titan.util.stats.NumberUtil;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class KCVSLogManager
implements LogManager {
    private static final Logger log = LoggerFactory.getLogger(KCVSLogManager.class);
    public static final ConfigOption<Boolean> LOG_FIXED_PARTITION = new ConfigOption<Boolean>(GraphDatabaseConfiguration.LOG_NS, "fixed-partition", "Whether all log entries are written to one fixed partition even if the backend store is partitioned.This can cause imbalanced loads and should only be used on low volume logs", ConfigOption.Type.GLOBAL_OFFLINE, false);
    public static final ConfigOption<Integer> LOG_MAX_PARTITIONS = new ConfigOption<1>(GraphDatabaseConfiguration.LOG_NS, "max-partitions", "The maximum number of partitions to use for logging. Setting up this many actual or virtual partitions. Must be bigger than 0and a power of 2.", ConfigOption.Type.FIXED, (Class<1>)Integer.class, new Predicate<Integer>(){

        public boolean apply(@Nullable Integer integer) {
            return integer != null && integer > 0 && NumberUtil.isPowerOf2(integer.intValue());
        }
    });
    public static final int CLUSTER_SIZE_DIVIDER = 8;
    private final Configuration configuration;
    final KeyColumnValueStoreManager storeManager;
    final String senderId;
    final int partitionBitWidth;
    final int[] defaultWritePartitionIds;
    final int[] readPartitionIds;
    final StandardSerializer serializer;
    private final Map<String, KCVSLog> openLogs;
    private final int indexStoreTTL;

    public KCVSLogManager(KeyColumnValueStoreManager storeManager, Configuration config) {
        this(storeManager, config, null);
    }

    public KCVSLogManager(KeyColumnValueStoreManager storeManager, Configuration config, int[] readPartitionIds) {
        Preconditions.checkArgument((storeManager != null && config != null ? 1 : 0) != 0);
        if (config.has(GraphDatabaseConfiguration.LOG_STORE_TTL, new String[0])) {
            this.indexStoreTTL = ConversionHelper.getTTLSeconds(config.get(GraphDatabaseConfiguration.LOG_STORE_TTL, new String[0]));
            StoreFeatures storeFeatures = storeManager.getFeatures();
            if (storeFeatures.hasCellTTL() && !storeFeatures.hasStoreTTL()) {
                storeManager = new TTLKCVSManager(storeManager);
            } else if (!storeFeatures.hasStoreTTL()) {
                log.warn("Log is configured with TTL but underlying storage backend does not support TTL, hence thisconfiguration option is ignored and entries must be manually removed from the backend.");
            }
        } else {
            this.indexStoreTTL = -1;
        }
        this.storeManager = storeManager;
        this.configuration = config;
        this.openLogs = new HashMap<String, KCVSLog>();
        this.senderId = config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]);
        Preconditions.checkNotNull((Object)this.senderId);
        int maxPartitions = config.has(LOG_MAX_PARTITIONS, new String[0]) ? config.get(LOG_MAX_PARTITIONS, new String[0]) : Math.max(1, config.get(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, new String[0]) / 8);
        Preconditions.checkArgument((maxPartitions <= config.get(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, new String[0]) ? 1 : 0) != 0, (Object)"Number of log partitions cannot be larger than number of cluster partitions");
        this.partitionBitWidth = NumberUtil.getPowerOf2(maxPartitions);
        Preconditions.checkArgument((this.partitionBitWidth >= 0 && this.partitionBitWidth < 32 ? 1 : 0) != 0);
        int numPartitions = 1 << this.partitionBitWidth;
        if (this.partitionBitWidth > 0 && !config.get(LOG_FIXED_PARTITION, new String[0]).booleanValue()) {
            int i;
            int[] writePartitions = new int[numPartitions];
            for (i = 0; i < numPartitions; ++i) {
                writePartitions[i] = i;
            }
            if (storeManager.getFeatures().hasLocalKeyPartition()) {
                ArrayList<Integer> localPartitions = new ArrayList<Integer>();
                try {
                    List<PartitionIDRange> partitionRanges = PartitionIDRange.getIDRanges(this.partitionBitWidth, storeManager.getLocalKeyPartition());
                    for (PartitionIDRange idrange : partitionRanges) {
                        for (int p : idrange.getAllContainedIDs()) {
                            localPartitions.add(p);
                        }
                    }
                }
                catch (Throwable e) {
                    log.error("Could not process local id partitions", e);
                }
                if (!localPartitions.isEmpty()) {
                    writePartitions = ArrayUtils.toPrimitive((Integer[])localPartitions.toArray(new Integer[localPartitions.size()]));
                }
            }
            this.defaultWritePartitionIds = writePartitions;
            if (readPartitionIds != null && readPartitionIds.length > 0) {
                for (int readPartitionId : readPartitionIds) {
                    KCVSLogManager.checkValidPartitionId(readPartitionId, this.partitionBitWidth);
                }
                this.readPartitionIds = Arrays.copyOf(readPartitionIds, readPartitionIds.length);
            } else {
                this.readPartitionIds = new int[numPartitions];
                for (i = 0; i < numPartitions; ++i) {
                    this.readPartitionIds[i] = i;
                }
            }
        } else {
            this.defaultWritePartitionIds = new int[]{0};
            Preconditions.checkArgument((readPartitionIds == null || readPartitionIds.length == 0 && readPartitionIds[0] == 0 ? 1 : 0) != 0, (Object)"Cannot configure read partition ids on unpartitioned backend or with fixed partitions enabled");
            this.readPartitionIds = new int[]{0};
        }
        this.serializer = new StandardSerializer();
    }

    private static void checkValidPartitionId(int partitionId, int partitionBitWidth) {
        Preconditions.checkArgument((partitionId >= 0 && partitionId < 1 << partitionBitWidth ? 1 : 0) != 0);
    }

    @Override
    public synchronized KCVSLog openLog(String name) throws BackendException {
        if (this.openLogs.containsKey(name)) {
            return this.openLogs.get(name);
        }
        StoreMetaData.Container storeOptions = new StoreMetaData.Container();
        if (0 < this.indexStoreTTL) {
            storeOptions.put(StoreMetaData.TTL, this.indexStoreTTL);
        }
        KCVSLog log = new KCVSLog(name, this, this.storeManager.openDatabase(name, storeOptions), this.configuration);
        this.openLogs.put(name, log);
        return log;
    }

    synchronized void closedLog(KCVSLog log) {
        KCVSLog l = this.openLogs.remove(log.getName());
        assert (l == log);
    }

    @Override
    public synchronized void close() throws BackendException {
        for (KCVSLog log : ImmutableMap.copyOf(this.openLogs).values()) {
            log.close();
        }
        IOUtils.closeQuietly(this.serializer);
    }
}

