/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap.computer;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraUtil;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraVertexMemory;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraVertexProperty;
import com.thinkaurelius.titan.graphdb.vertices.PreloadedVertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

class VertexMemoryHandler<M>
implements PreloadedVertex.PropertyMixing,
Messenger<M> {
    protected final FulgoraVertexMemory<M> vertexMemory;
    private final PreloadedVertex vertex;
    protected final long vertexId;

    VertexMemoryHandler(FulgoraVertexMemory<M> vertexMemory, PreloadedVertex vertex) {
        assert (vertex != null && vertexMemory != null);
        this.vertexMemory = vertexMemory;
        this.vertex = vertex;
        this.vertexId = vertexMemory.getCanonicalId(vertex.longId());
    }

    void removeKey(String key) {
        this.vertexMemory.setProperty(this.vertexId, key, null);
    }

    <V> TitanVertexProperty<V> constructProperty(String key, V value) {
        assert (key != null && value != null);
        return new FulgoraVertexProperty<V>(this, this.vertex, key, value);
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        if (this.vertexMemory.elementKeyMap.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (keys == null || keys.length == 0) {
            return Collections.emptyIterator();
        }
        ArrayList result = new ArrayList(Math.min(keys.length, this.vertexMemory.elementKeyMap.size()));
        for (String key : keys) {
            Object value;
            if (!this.supports(key) || (value = this.vertexMemory.getProperty(this.vertexId, key)) == null) continue;
            result.add(this.constructProperty(key, value));
        }
        return result.iterator();
    }

    @Override
    public boolean supports(String key) {
        return this.vertexMemory.elementKeyMap.containsKey(key);
    }

    @Override
    public <V> TitanVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value) {
        if (!this.supports(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)key);
        }
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        Preconditions.checkArgument((cardinality == VertexProperty.Cardinality.single ? 1 : 0) != 0, (String)"Only single cardinality is supported, provided: %s", (Object[])new Object[]{cardinality});
        this.vertexMemory.setProperty(this.vertexId, key, value);
        return this.constructProperty(key, value);
    }

    public Stream<M> receiveMessages(MessageScope messageScope) {
        if (messageScope instanceof MessageScope.Global) {
            M message = this.vertexMemory.getMessage(this.vertexId, messageScope);
            if (message == null) {
                return Stream.empty();
            }
            return Stream.of(message);
        }
        MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
        Traversal<Vertex, Edge> reverseIncident = FulgoraUtil.getReverseElementTraversal(localMessageScope, this.vertex, this.vertex.tx());
        BiFunction edgeFct = localMessageScope.getEdgeFunction();
        return IteratorUtils.stream(reverseIncident).map(e -> {
            M msg = this.vertexMemory.getMessage(this.vertexMemory.getCanonicalId(((TitanEdge)e).otherVertex(this.vertex).longId()), (MessageScope)localMessageScope);
            return msg == null ? null : edgeFct.apply(msg, e);
        }).filter(m -> m != null);
    }

    public Iterator<M> receiveMessages() {
        Stream<Object> combinedStream = Stream.empty();
        for (MessageScope scope : this.vertexMemory.getPreviousScopes()) {
            combinedStream = Stream.concat(this.receiveMessages(scope), combinedStream);
        }
        return combinedStream.iterator();
    }

    public void sendMessage(MessageScope messageScope, M m) {
        if (messageScope instanceof MessageScope.Local) {
            this.vertexMemory.sendMessage(this.vertexId, m, messageScope);
        } else {
            ((MessageScope.Global)messageScope).vertices().forEach(v -> {
                long vertexId = v instanceof TitanVertex ? ((TitanVertex)v).longId() : ((Long)v.id()).longValue();
                this.vertexMemory.sendMessage(this.vertexMemory.getCanonicalId(vertexId), m, messageScope);
            });
        }
    }

    static class Partition<M>
    extends VertexMemoryHandler<M> {
        Partition(FulgoraVertexMemory<M> vertexMemory, PreloadedVertex vertex) {
            super(vertexMemory, vertex);
        }

        @Override
        public Stream<M> receiveMessages(MessageScope messageScope) {
            if (messageScope instanceof MessageScope.Global) {
                return super.receiveMessages(messageScope);
            }
            MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
            Object aggregateMsg = this.vertexMemory.getAggregateMessage(this.vertexId, (MessageScope)localMessageScope);
            if (aggregateMsg == null) {
                return Stream.empty();
            }
            return Stream.of(aggregateMsg);
        }
    }
}

