/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import com.thinkaurelius.titan.graphdb.util.ElementHelper;
import java.util.Iterator;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class PredicateCondition<K, E extends TitanElement>
extends Literal<E> {
    private final K key;
    private final TitanPredicate predicate;
    private final Object value;

    public PredicateCondition(K key, TitanPredicate predicate, Object value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkArgument((key instanceof String || key instanceof RelationType ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)predicate);
        this.key = key;
        this.predicate = predicate;
        this.value = value;
    }

    private boolean satisfiesCondition(Object value) {
        return this.predicate.test(value, this.value);
    }

    @Override
    public boolean evaluate(E element) {
        RelationType type;
        if (this.key instanceof String) {
            type = ((InternalElement)element).tx().getRelationType((String)this.key);
            if (type == null) {
                return this.satisfiesCondition(null);
            }
        } else {
            type = (RelationType)this.key;
        }
        Preconditions.checkNotNull((Object)type);
        if (type.isPropertyKey()) {
            Iterator<Object> iter = ElementHelper.getValues(element, (PropertyKey)type).iterator();
            if (iter.hasNext()) {
                while (iter.hasNext()) {
                    if (!this.satisfiesCondition(iter.next())) continue;
                    return true;
                }
                return false;
            }
            return this.satisfiesCondition(null);
        }
        assert (((InternalRelationType)type).multiplicity().isUnique(Direction.OUT));
        return this.satisfiesCondition((TitanVertex)element.value(type.name()));
    }

    public K getKey() {
        return this.key;
    }

    public TitanPredicate getPredicate() {
        return this.predicate;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append(this.key).append((Object)this.predicate).append(this.value).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        PredicateCondition oth = (PredicateCondition)other;
        return this.key.equals(oth.key) && this.predicate.equals(oth.predicate) && this.value.equals(oth.value);
    }

    @Override
    public String toString() {
        return this.key.toString() + " " + this.predicate.toString() + " " + String.valueOf(this.value);
    }

    public static <K, E extends TitanElement> PredicateCondition<K, E> of(K key, TitanPredicate titanPredicate, Object condition) {
        return new PredicateCondition<K, E>(key, titanPredicate, condition);
    }
}

