/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class MultiVertexCentricQueryBuilder
extends BasicVertexCentricQueryBuilder<MultiVertexCentricQueryBuilder>
implements TitanMultiVertexQuery<MultiVertexCentricQueryBuilder> {
    private final Set<InternalVertex> vertices = Sets.newHashSet();

    public MultiVertexCentricQueryBuilder(StandardTitanTx tx) {
        super(tx);
    }

    @Override
    protected MultiVertexCentricQueryBuilder getThis() {
        return this;
    }

    @Override
    public TitanMultiVertexQuery addVertex(Vertex vertex) {
        assert (vertex != null);
        assert (vertex instanceof InternalVertex);
        this.vertices.add(((InternalVertex)vertex).it());
        return this;
    }

    @Override
    public TitanMultiVertexQuery addAllVertices(Collection<? extends Vertex> vertices) {
        for (Vertex vertex : vertices) {
            this.addVertex(vertex);
        }
        return this;
    }

    protected <Q> Map<TitanVertex, Q> execute(RelationCategory returnType, BasicVertexCentricQueryBuilder.ResultConstructor<Q> resultConstructor) {
        Preconditions.checkArgument((!this.vertices.isEmpty() ? 1 : 0) != 0, (Object)"Need to add at least one vertex to query");
        HashMap<TitanVertex, Q> result = new HashMap<TitanVertex, Q>(this.vertices.size());
        BaseVertexCentricQuery bq = super.constructQuery(returnType);
        this.profiler.setAnnotation("multi", true);
        this.profiler.setAnnotation("vertices", this.vertices.size());
        if (!bq.isEmpty()) {
            for (BackendQueryHolder<SliceQuery> backendQueryHolder : bq.getQueries()) {
                HashSet adjVertices = Sets.newHashSet(this.vertices);
                for (InternalVertex v : this.vertices) {
                    if (!this.isPartitionedVertex(v)) continue;
                    this.profiler.setAnnotation("partitioned", true);
                    adjVertices.remove(v);
                    adjVertices.addAll(this.allRequiredRepresentatives(v));
                }
                this.profiler.setAnnotation("vertices", adjVertices.size());
                this.tx.executeMultiQuery(adjVertices, backendQueryHolder.getBackendQuery(), backendQueryHolder.getProfiler());
            }
            for (InternalVertex internalVertex : this.vertices) {
                result.put(internalVertex, resultConstructor.getResult(internalVertex, bq));
            }
        } else {
            for (TitanVertex titanVertex : this.vertices) {
                result.put(titanVertex, resultConstructor.emptyResult());
            }
        }
        return result;
    }

    public Map<TitanVertex, Iterable<? extends TitanRelation>> executeImplicitKeyQuery() {
        return new HashMap<TitanVertex, Iterable<? extends TitanRelation>>(this.vertices.size()){
            {
                for (InternalVertex v : MultiVertexCentricQueryBuilder.this.vertices) {
                    this.put(v, MultiVertexCentricQueryBuilder.this.executeImplicitKeyQuery(v));
                }
            }
        };
    }

    @Override
    public Map<TitanVertex, Iterable<TitanEdge>> edges() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Map<TitanVertex, Iterable<TitanVertexProperty>> properties() {
        return this.isImplicitKeyQuery(RelationCategory.PROPERTY) ? this.executeImplicitKeyQuery() : this.execute(RelationCategory.PROPERTY, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Map<TitanVertex, Iterable<TitanRelation>> relations() {
        return this.isImplicitKeyQuery(RelationCategory.RELATION) ? this.executeImplicitKeyQuery() : this.execute(RelationCategory.RELATION, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Map<TitanVertex, Iterable<TitanVertex>> vertices() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexConstructor(this));
    }

    @Override
    public Map<TitanVertex, VertexList> vertexIds() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexIdConstructor(this));
    }
}

