/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.ElementQuery;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.relations.RelationComparator;
import java.util.Comparator;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class VertexCentricQuery
extends BaseVertexCentricQuery
implements ElementQuery<TitanRelation, SliceQuery> {
    private final InternalVertex vertex;

    public VertexCentricQuery(InternalVertex vertex, Condition<TitanRelation> condition, Direction direction, List<BackendQueryHolder<SliceQuery>> queries, OrderList orders, int limit) {
        super(condition, direction, queries, orders, limit);
        Preconditions.checkNotNull((Object)vertex);
        this.vertex = vertex;
    }

    public VertexCentricQuery(InternalVertex vertex, BaseVertexCentricQuery base) {
        super(base);
        Preconditions.checkNotNull((Object)vertex);
        this.vertex = vertex;
    }

    protected VertexCentricQuery(InternalVertex vertex) {
        Preconditions.checkNotNull((Object)vertex);
        this.vertex = vertex;
    }

    public static VertexCentricQuery emptyQuery(InternalVertex vertex) {
        return new VertexCentricQuery(vertex);
    }

    public InternalVertex getVertex() {
        return this.vertex;
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public Comparator getSortOrder() {
        return new RelationComparator(this.vertex, this.getOrders());
    }

    @Override
    public boolean hasDuplicateResults() {
        return false;
    }

    @Override
    public String toString() {
        return this.vertex + super.toString();
    }
}

