/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.vertices;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.InvalidElementException;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.graphdb.util.ElementHelper;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public abstract class AbstractVertex
extends AbstractElement
implements InternalVertex,
Vertex {
    private final StandardTitanTx tx;

    protected AbstractVertex(StandardTitanTx tx, long id) {
        super(id);
        assert (tx != null);
        this.tx = tx;
    }

    @Override
    public final InternalVertex it() {
        if (this.tx.isOpen()) {
            return this;
        }
        InternalVertex next = (InternalVertex)this.tx.getNextTx().getVertex(this.longId());
        if (next == null) {
            throw InvalidElementException.removedException(this);
        }
        return next;
    }

    @Override
    public final StandardTitanTx tx() {
        return this.tx.isOpen() ? this.tx : this.tx.getNextTx();
    }

    @Override
    public long getCompareId() {
        if (this.tx.isPartitionedVertex(this)) {
            return this.tx.getIdInspector().getCanonicalVertexId(this.longId());
        }
        return this.longId();
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    @Override
    public Object id() {
        return this.longId();
    }

    @Override
    public boolean isModified() {
        return ElementLifeCycle.isModified(this.it().getLifeCycle());
    }

    protected final void verifyAccess() {
        if (this.isRemoved()) {
            throw InvalidElementException.removedException(this);
        }
    }

    @Override
    public synchronized void remove() {
        this.verifyAccess();
        Iterator<TitanRelation> iter = ((VertexCentricQueryBuilder)this.it().query().noPartitionRestriction()).relations().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        for (TitanRelation r : ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.it().query().noPartitionRestriction()).system()).relations()) {
            RelationType t = r.getType();
            r.remove();
        }
    }

    @Override
    public String label() {
        return this.vertexLabel().name();
    }

    protected Vertex getVertexLabelInternal() {
        return (Vertex)Iterables.getOnlyElement(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.tx().query(this).noPartitionRestriction()).type(BaseLabel.VertexLabelEdge)).direction(Direction.OUT)).vertices(), null);
    }

    @Override
    public VertexLabel vertexLabel() {
        Vertex label = this.getVertexLabelInternal();
        if (label == null) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        return (VertexLabelVertex)label;
    }

    @Override
    public VertexCentricQueryBuilder query() {
        this.verifyAccess();
        return this.tx().query(this);
    }

    public <O> O valueOrNull(PropertyKey key) {
        return (O)this.property(key.name()).orElse(null);
    }

    @Override
    public <V> TitanVertexProperty<V> property(String key, V value, Object ... keyValues) {
        TitanVertexProperty p = this.tx().addProperty(this.it(), this.tx().getOrCreatePropertyKey(key), value);
        ElementHelper.attachProperties(p, keyValues);
        return p;
    }

    @Override
    public <V> TitanVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        TitanVertexProperty p = this.tx().addProperty(cardinality, this.it(), this.tx().getOrCreatePropertyKey(key), value);
        ElementHelper.attachProperties(p, keyValues);
        return p;
    }

    @Override
    public TitanEdge addEdge(String label, Vertex vertex, Object ... keyValues) {
        Preconditions.checkArgument((boolean)(vertex instanceof TitanVertex), (String)"Invalid vertex provided: %s", (Object[])new Object[]{vertex});
        TitanEdge edge = this.tx().addEdge(this.it(), (TitanVertex)vertex, this.tx().getOrCreateEdgeLabel(label));
        ElementHelper.attachProperties(edge, keyValues);
        return edge;
    }

    public Iterator<Edge> edges(Direction direction, String ... labels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(direction)).labels(labels)).edges().iterator();
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(Direction.OUT)).keys(keys)).properties().iterator();
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(direction)).labels(edgeLabels)).vertices().iterator();
    }
}

