/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchConstants;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchSetup;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.util.DefaultTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.internal.Order;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class ElasticSearchIndex
implements IndexProvider {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchIndex.class);
    private static final String TTL_FIELD = "_ttl";
    private static final String STRING_MAPPING_SUFFIX = "__STRING";
    public static final ImmutableList<String> DATA_SUBDIRS = ImmutableList.of((Object)"data", (Object)"work", (Object)"logs");
    public static final ConfigNamespace ELASTICSEARCH_NS = new ConfigNamespace(GraphDatabaseConfiguration.INDEX_NS, "elasticsearch", "Elasticsearch index configuration");
    public static final ConfigOption<Boolean> CLIENT_ONLY = new ConfigOption(ELASTICSEARCH_NS, "client-only", "The Elasticsearch node.client option is set to this boolean value, and the Elasticsearch node.data option is set to the negation of this value.  True creates a thin client which holds no data.  False creates a regular Elasticsearch cluster node that may store data.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)true);
    public static final ConfigOption<String> CLUSTER_NAME = new ConfigOption(ELASTICSEARCH_NS, "cluster-name", "The name of the Elasticsearch cluster.  This should match the \"cluster.name\" setting in the Elasticsearch nodes' configuration.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"elasticsearch");
    public static final ConfigOption<Boolean> LOCAL_MODE = new ConfigOption(ELASTICSEARCH_NS, "local-mode", "On the legacy config track, this option chooses between starting a TransportClient (false) or a Node with JVM-local transport and local data (true).  On the interface config track, this option is considered by (but optional for) the Node client and ignored by the TransportClient.  See the manual for more information about ES config tracks.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)false);
    public static final ConfigOption<Boolean> CLIENT_SNIFF = new ConfigOption(ELASTICSEARCH_NS, "sniff", "Whether to enable cluster sniffing.  This option only applies to the TransportClient.  Enabling this option makes the TransportClient attempt to discover other cluster nodes besides those in the initial host list provided at startup.", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<String> INTERFACE = new ConfigOption(ELASTICSEARCH_NS, "interface", "Whether to connect to ES using the Node or Transport client (see the \"Talking to Elasticsearch\" section of the ES manual for discussion of the difference).  Setting this option enables the interface config track (see manual for more information about ES config tracks).", ConfigOption.Type.MASKABLE, String.class, (Object)ElasticSearchSetup.TRANSPORT_CLIENT.toString(), ConfigOption.disallowEmpty(String.class));
    public static final ConfigOption<Boolean> IGNORE_CLUSTER_NAME = new ConfigOption(ELASTICSEARCH_NS, "ignore-cluster-name", "Whether to bypass validation of the cluster name of connected nodes.  This option is only used on the interface configuration track (see manual for information about ES config tracks).", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<String> TTL_INTERVAL = new ConfigOption(ELASTICSEARCH_NS, "ttl-interval", "The period of time between runs of ES's bulit-in expired document deleter.  This string will become the value of ES's indices.ttl.interval setting and should be formatted accordingly, e.g. 5s or 60s.", ConfigOption.Type.MASKABLE, (Object)"5s");
    public static final ConfigOption<String> HEALTH_REQUEST_TIMEOUT = new ConfigOption(ELASTICSEARCH_NS, "health-request-timeout", "When Titan initializes its ES backend, Titan waits up to this duration for the ES cluster health to reach at least yellow status.  This string should be formatted as a natural number followed by the lowercase letter \"s\", e.g. 3s or 60s.", ConfigOption.Type.MASKABLE, (Object)"30s");
    public static final ConfigOption<Boolean> LOAD_DEFAULT_NODE_SETTINGS = new ConfigOption(ELASTICSEARCH_NS, "load-default-node-settings", "Whether ES's Node client will internally attempt to load default configuration settings from system properties/process environment variables.  Only meaningful when using the Node client (has no effect with TransportClient).", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<Boolean> USE_EDEPRECATED_IGNORE_UNMAPPED_OPTION = new ConfigOption(ELASTICSEARCH_NS, "use-deprecated-ignore-unmapped-option", "Elasticsearch versions before 1.4.0 supported the \"ignore_unmapped\" sort option. In 1.4.0, it was deprecated by the new \"unmapped_type\" sort option.  This configurationsetting controls which ES option Titan uses: false for the newer \"unmapped_type\",true for the older \"ignore_unmapped\".", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigNamespace ES_EXTRAS_NS = new ConfigNamespace(ELASTICSEARCH_NS, "ext", "Overrides for arbitrary elasticsearch.yaml settings", true);
    public static final ConfigNamespace ES_CREATE_NS = new ConfigNamespace(ELASTICSEARCH_NS, "create", "Settings related to index creation");
    public static final ConfigOption<Long> CREATE_SLEEP = new ConfigOption(ES_CREATE_NS, "sleep", "How long to sleep, in milliseconds, between the successful completion of a (blocking) index creation request and the first use of that index.  This only applies when creating an index in ES, which typically only happens the first time Titan is started on top of ES. If the index Titan is configured to use already exists, then this setting has no effect.", ConfigOption.Type.MASKABLE, (Object)200L);
    public static final ConfigNamespace ES_CREATE_EXTRAS_NS = new ConfigNamespace(ES_CREATE_NS, "ext", "Overrides for arbitrary settings applied at index creation", true);
    private static final IndexFeatures ES_FEATURES = new IndexFeatures.Builder().supportsDocumentTTL().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.TEXTSTRING, Mapping.STRING}).setWildcardField("_all").supportsCardinality(Cardinality.SINGLE).supportsCardinality(Cardinality.LIST).supportsCardinality(Cardinality.SET).supportsNanoseconds().build();
    public static final int HOST_PORT_DEFAULT = 9300;
    public static final int DEFAULT_GEO_MAX_LEVELS = 20;
    public static final double DEFAULT_GEO_DIST_ERROR_PCT = 0.025;
    private static final Map<Geo, ShapeRelation> SPATIAL_PREDICATES = ElasticSearchIndex.spatialPredicates();
    private final Node node;
    private final Client client;
    private final String indexName;
    private final int maxResultsSize;
    private final boolean useDeprecatedIgnoreUnmapped;

    public ElasticSearchIndex(Configuration config) {
        this.indexName = (String)config.get(GraphDatabaseConfiguration.INDEX_NAME, new String[0]);
        this.useDeprecatedIgnoreUnmapped = (Boolean)config.get(USE_EDEPRECATED_IGNORE_UNMAPPED_OPTION, new String[0]);
        this.checkExpectedClientVersion();
        ElasticSearchSetup.Connection c = !config.has(INTERFACE, new String[0]) ? this.legacyConfiguration(config) : this.interfaceConfiguration(config);
        this.node = c.getNode();
        this.client = c.getClient();
        this.maxResultsSize = (Integer)config.get(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, new String[0]);
        log.debug("Configured ES query result set max size to {}", (Object)this.maxResultsSize);
        this.client.admin().cluster().prepareHealth(new String[0]).setTimeout((String)config.get(HEALTH_REQUEST_TIMEOUT, new String[0])).setWaitForYellowStatus().execute().actionGet();
        this.checkForOrCreateIndex(config);
    }

    private void checkForOrCreateIndex(Configuration config) {
        Preconditions.checkState((null != this.client ? 1 : 0) != 0);
        IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.indexName})).actionGet();
        if (!response.isExists()) {
            Settings.Builder settings = Settings.settingsBuilder();
            ElasticSearchSetup.applySettingsFromTitanConf(settings, config, ES_CREATE_EXTRAS_NS);
            CreateIndexResponse create = (CreateIndexResponse)this.client.admin().indices().prepareCreate(this.indexName).setSettings(settings.build()).execute().actionGet();
            try {
                long sleep = (Long)config.get(CREATE_SLEEP, new String[0]);
                log.debug("Sleeping {} ms after {} index creation returned from actionGet()", (Object)sleep, (Object)this.indexName);
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw new TitanException("Interrupted while waiting for index to settle in", (Throwable)e);
            }
            if (!create.isAcknowledged()) {
                throw new IllegalArgumentException("Could not create index: " + this.indexName);
            }
        }
    }

    private ElasticSearchSetup.Connection interfaceConfiguration(Configuration config) {
        ElasticSearchSetup clientMode = (ElasticSearchSetup)ConfigOption.getEnumValue((String)((String)config.get(INTERFACE, new String[0])), ElasticSearchSetup.class);
        try {
            return clientMode.connect(config);
        }
        catch (IOException e) {
            throw new TitanException((Throwable)e);
        }
    }

    private ElasticSearchSetup.Connection legacyConfiguration(Configuration config) {
        TransportClient client;
        Node node;
        block16: {
            block13: {
                NodeBuilder builder;
                boolean local;
                boolean clientOnly;
                block15: {
                    block14: {
                        if (!((Boolean)config.get(LOCAL_MODE, new String[0])).booleanValue()) break block13;
                        log.debug("Configuring ES for JVM local transport");
                        clientOnly = (Boolean)config.get(CLIENT_ONLY, new String[0]);
                        local = (Boolean)config.get(LOCAL_MODE, new String[0]);
                        builder = NodeBuilder.nodeBuilder();
                        Preconditions.checkArgument((config.has(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0]) || config.has(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]) ? 1 : 0) != 0, (Object)"Must either configure configuration file or base directory");
                        if (!config.has(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0])) break block14;
                        String configFile = (String)config.get(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0]);
                        Settings.Builder sb = Settings.settingsBuilder();
                        sb.put("path.home", System.getProperty("java.io.tmpdir"));
                        log.debug("Configuring ES from YML file [{}]", (Object)configFile);
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(configFile);
                            sb.loadFromStream(configFile, (InputStream)fis);
                            builder.settings(sb.build());
                        }
                        catch (FileNotFoundException e) {
                            try {
                                throw new TitanException((Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fis);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Closeable)fis);
                        break block15;
                    }
                    String dataDirectory = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
                    log.debug("Configuring ES with data directory [{}]", (Object)dataDirectory);
                    File f = new File(dataDirectory);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    Settings.Builder b = Settings.settingsBuilder();
                    for (String sub : DATA_SUBDIRS) {
                        String subdir = dataDirectory + File.separator + sub;
                        f = new File(subdir);
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                        b.put("path." + sub, subdir);
                    }
                    b.put("script.inline", "on");
                    b.put("indices.ttl.interval", "5s");
                    b.put("path.home", System.getProperty("java.io.tmpdir"));
                    builder.settings(b.build());
                    String clustername = (String)config.get(CLUSTER_NAME, new String[0]);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
                    builder.clusterName(clustername);
                }
                builder.getSettings().put("index.max_result_window", Integer.MAX_VALUE);
                node = builder.client(clientOnly).data(!clientOnly).local(local).node();
                client = node.client();
                break block16;
            }
            log.debug("Configuring ES for network transport");
            Settings.Builder settings = Settings.settingsBuilder();
            if (config.has(CLUSTER_NAME, new String[0])) {
                String clustername = (String)config.get(CLUSTER_NAME, new String[0]);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
                settings.put("cluster.name", clustername);
            } else {
                settings.put("client.transport.ignore_cluster_name", true);
            }
            log.debug("Transport sniffing enabled: {}", config.get(CLIENT_SNIFF, new String[0]));
            settings.put("client.transport.sniff", ((Boolean)config.get(CLIENT_SNIFF, new String[0])).booleanValue());
            settings.put("script.inline", "on");
            settings.put("index.max_result_window", Integer.MAX_VALUE);
            TransportClient tc = TransportClient.builder().settings(settings.build()).build();
            int defaultPort = config.has(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) ? (Integer)config.get(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) : 9300;
            for (String host : (String[])config.get(GraphDatabaseConfiguration.INDEX_HOSTS, new String[0])) {
                String[] hostparts = host.split(":");
                String hostname = hostparts[0];
                int hostport = defaultPort;
                if (hostparts.length == 2) {
                    hostport = Integer.parseInt(hostparts[1]);
                }
                log.info("Configured remote host: {} : {}", (Object)hostname, (Object)hostport);
                try {
                    tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostname), hostport));
                }
                catch (UnknownHostException e) {
                    log.error("unknown host", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            client = tc;
            node = null;
        }
        return new ElasticSearchSetup.Connection(node, (Client)client);
    }

    private BackendException convert(Exception esException) {
        if (esException instanceof InterruptedException) {
            return new TemporaryBackendException("Interrupted while waiting for response", (Throwable)esException);
        }
        return new PermanentBackendException("Unknown exception while executing index operation", (Throwable)esException);
    }

    private static String getDualMappingName(String key) {
        return key + STRING_MAPPING_SUFFIX;
    }

    private static Map<Geo, ShapeRelation> spatialPredicates() {
        return Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Geo, ShapeRelation>(Geo.WITHIN, ShapeRelation.WITHIN), new AbstractMap.SimpleEntry<Geo, ShapeRelation>(Geo.CONTAINS, ShapeRelation.CONTAINS), new AbstractMap.SimpleEntry<Geo, ShapeRelation>(Geo.INTERSECT, ShapeRelation.INTERSECTS), new AbstractMap.SimpleEntry<Geo, ShapeRelation>(Geo.DISJOINT, ShapeRelation.DISJOINT)).collect(Collectors.toMap(e -> (Geo)e.getKey(), e -> (ShapeRelation)e.getValue())));
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        XContentBuilder mapping;
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtil.isString((Class)dataType) || map == Mapping.PREFIX_TREE && AttributeUtil.isGeo((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object[])new Object[]{map, dataType});
        try {
            block35: {
                block34: {
                    mapping = XContentFactory.jsonBuilder().startObject().startObject(store).field(TTL_FIELD, (Map)new HashMap<String, Object>(){
                        {
                            this.put("enabled", true);
                        }
                    }).startObject("properties").startObject(key);
                    if (!AttributeUtil.isString((Class)dataType)) break block34;
                    if (map == Mapping.DEFAULT) {
                        map = Mapping.TEXT;
                    }
                    log.debug("Registering string type for {} with mapping {}", (Object)key, (Object)map);
                    mapping.field("type", "string");
                    switch (map) {
                        case STRING: {
                            mapping.field("index", "not_analyzed");
                            break block35;
                        }
                        case TEXT: {
                            break block35;
                        }
                        case TEXTSTRING: {
                            mapping.endObject();
                            mapping.startObject(ElasticSearchIndex.getDualMappingName(key));
                            mapping.field("type", "string");
                            mapping.field("index", "not_analyzed");
                            break block35;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected mapping: " + map));
                        }
                    }
                }
                if (dataType == Float.class) {
                    log.debug("Registering float type for {}", (Object)key);
                    mapping.field("type", "float");
                } else if (dataType == Double.class) {
                    log.debug("Registering double type for {}", (Object)key);
                    mapping.field("type", "double");
                } else if (dataType == Byte.class) {
                    log.debug("Registering byte type for {}", (Object)key);
                    mapping.field("type", "byte");
                } else if (dataType == Short.class) {
                    log.debug("Registering short type for {}", (Object)key);
                    mapping.field("type", "short");
                } else if (dataType == Integer.class) {
                    log.debug("Registering integer type for {}", (Object)key);
                    mapping.field("type", "integer");
                } else if (dataType == Long.class) {
                    log.debug("Registering long type for {}", (Object)key);
                    mapping.field("type", "long");
                } else if (dataType == Boolean.class) {
                    log.debug("Registering boolean type for {}", (Object)key);
                    mapping.field("type", "boolean");
                } else if (dataType == Geoshape.class) {
                    switch (map) {
                        case PREFIX_TREE: {
                            int maxLevels = (Integer)ParameterType.INDEX_GEO_MAX_LEVELS.findParameter(information.getParameters(), (Object)20);
                            double distErrorPct = (Double)ParameterType.INDEX_GEO_DIST_ERROR_PCT.findParameter(information.getParameters(), (Object)0.025);
                            log.debug("Registering geo_shape type for {} with tree_levels={} and distance_error_pct={}", new Object[]{key, maxLevels, distErrorPct});
                            mapping.field("type", "geo_shape");
                            mapping.field("tree", "quadtree");
                            mapping.field("tree_levels", maxLevels);
                            mapping.field("distance_error_pct", distErrorPct);
                            break;
                        }
                        default: {
                            log.debug("Registering geo_point type for {}", (Object)key);
                            mapping.field("type", "geo_point");
                            break;
                        }
                    }
                } else if (dataType == Date.class || dataType == Instant.class) {
                    log.debug("Registering date type for {}", (Object)key);
                    mapping.field("type", "date");
                } else if (dataType == Boolean.class) {
                    log.debug("Registering boolean type for {}", (Object)key);
                    mapping.field("type", "boolean");
                } else if (dataType == UUID.class) {
                    log.debug("Registering uuid type for {}", (Object)key);
                    mapping.field("type", "string");
                    mapping.field("index", "not_analyzed");
                }
            }
            mapping.endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not render json for put mapping request", (Throwable)e);
        }
        try {
            PutMappingResponse e = (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{this.indexName}).setType(store).setSource(mapping).execute().actionGet();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    private static Mapping getStringMapping(KeyInformation information) {
        assert (AttributeUtil.isString((Class)information.getDataType()));
        Mapping map = Mapping.getMapping((KeyInformation)information);
        if (map == Mapping.DEFAULT) {
            map = Mapping.TEXT;
        }
        return map;
    }

    private static boolean hasDualStringMapping(KeyInformation information) {
        return AttributeUtil.isString((Class)information.getDataType()) && ElasticSearchIndex.getStringMapping(information) == Mapping.TEXTSTRING;
    }

    public XContentBuilder getNewDocument(List<IndexEntry> additions, KeyInformation.StoreRetriever informations) throws BackendException {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            LinkedListMultimap uniq = LinkedListMultimap.create();
            for (IndexEntry indexEntry : additions) {
                uniq.put((Object)indexEntry.field, (Object)indexEntry);
            }
            for (Map.Entry entry : uniq.asMap().entrySet()) {
                KeyInformation keyInformation = informations.get((String)entry.getKey());
                Object[] value = null;
                switch (keyInformation.getCardinality()) {
                    case SINGLE: {
                        value = ElasticSearchIndex.convertToEsType(((IndexEntry)Iterators.getLast(((Collection)entry.getValue()).iterator())).value);
                        break;
                    }
                    case SET: 
                    case LIST: {
                        value = ((Collection)entry.getValue()).stream().map(v -> ElasticSearchIndex.convertToEsType(v.value)).filter(v -> {
                            Preconditions.checkArgument((!(v instanceof byte[]) ? 1 : 0) != 0, (Object)("Collections not supported for " + (String)add.getKey()));
                            return true;
                        }).collect(Collectors.toList()).toArray();
                    }
                }
                if (value instanceof byte[]) {
                    builder.rawField((String)entry.getKey(), (InputStream)new ByteArrayInputStream((byte[])value));
                } else {
                    builder.field((String)entry.getKey(), (Object)value);
                }
                if (!ElasticSearchIndex.hasDualStringMapping(informations.get((String)entry.getKey())) || keyInformation.getDataType() != String.class) continue;
                builder.field(ElasticSearchIndex.getDualMappingName((String)entry.getKey()), (Object)value);
            }
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not write json");
        }
    }

    private static Object convertToEsType(Object value) {
        if (value instanceof Number) {
            if (AttributeUtil.isWholeNumber((Number)((Number)value))) {
                return ((Number)value).longValue();
            }
            return ((Number)value).doubleValue();
        }
        if (AttributeUtil.isString((Object)value)) {
            return value;
        }
        if (value instanceof Geoshape) {
            return ElasticSearchIndex.convertgeo((Geoshape)value);
        }
        if (value instanceof Date || value instanceof Instant) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass() + " (value: " + value + ")");
    }

    private static Object convertgeo(Geoshape geoshape) {
        if (geoshape.getType() == Geoshape.Type.POINT) {
            Geoshape.Point p = geoshape.getPoint();
            return new double[]{p.getLongitude(), p.getLatitude()};
        }
        if (geoshape.getType() != Geoshape.Type.BOX && geoshape.getType() != Geoshape.Type.CIRCLE) {
            return geoshape.toGeoJson().getBytes();
        }
        throw new IllegalArgumentException("Unsupported or invalid shape type for indexing: " + geoshape.getType());
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        BulkRequestBuilder brb = this.client.prepareBulk();
        int bulkrequests = 0;
        try {
            BulkResponse bulkItemResponses;
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String storename = stores.getKey();
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docid = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    assert (mutation.isConsolidated());
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            log.trace("Deleting entire document {}", (Object)docid);
                            brb.add(new DeleteRequest(this.indexName, storename, docid));
                        } else {
                            String script = this.getDeletionScript(informations, storename, mutation);
                            brb.add(this.client.prepareUpdate(this.indexName, storename, docid).setScript(new Script(script, ScriptService.ScriptType.INLINE, null, null)));
                            log.trace("Adding script {}", (Object)script);
                        }
                        ++bulkrequests;
                    }
                    if (!mutation.hasAdditions()) continue;
                    long ttl = (long)mutation.determineTTL() * 1000L;
                    if (mutation.isNew()) {
                        log.trace("Adding entire document {}", (Object)docid);
                        Preconditions.checkArgument((ttl >= 0L ? 1 : 0) != 0);
                        IndexRequest request = new IndexRequest(this.indexName, storename, docid).source(this.getNewDocument(mutation.getAdditions(), informations.get(storename)));
                        if (ttl > 0L) {
                            request.ttl(ttl);
                        }
                        brb.add(request);
                    } else {
                        Preconditions.checkArgument((ttl == 0L ? 1 : 0) != 0, (String)"Elasticsearch only supports TTL on new documents [%s]", (Object[])new Object[]{docid});
                        boolean needUpsert = !mutation.hasDeletions();
                        String script = this.getAdditionScript(informations, storename, mutation);
                        UpdateRequestBuilder update = this.client.prepareUpdate(this.indexName, storename, docid).setScript(new Script(script, ScriptService.ScriptType.INLINE, null, null));
                        if (needUpsert) {
                            XContentBuilder doc = this.getNewDocument(mutation.getAdditions(), informations.get(storename));
                            update.setUpsert(doc);
                        }
                        brb.add(update);
                        log.trace("Adding script {}", (Object)script);
                    }
                    ++bulkrequests;
                }
            }
            if (bulkrequests > 0 && (bulkItemResponses = (BulkResponse)brb.execute().actionGet()).hasFailures()) {
                boolean actualFailure = false;
                for (BulkItemResponse response : bulkItemResponses.getItems()) {
                    if (!response.isFailed() || response.getFailure().getStatus() == RestStatus.NOT_FOUND) continue;
                    StringWriter stackTraceString = new StringWriter();
                    PrintWriter stackTrace = new PrintWriter(stackTraceString);
                    response.getFailure().getCause().printStackTrace(stackTrace);
                    log.error("Failed to execute ES query {} {}", (Object)response.getFailureMessage(), (Object)stackTraceString);
                    actualFailure = true;
                }
                if (actualFailure) {
                    throw new Exception(bulkItemResponses.buildFailureMessage());
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to execute ES query {}", (Object)((BulkRequest)brb.request()).timeout(), (Object)e);
            throw this.convert(e);
        }
    }

    private String getDeletionScript(KeyInformation.IndexRetriever informations, String storename, IndexMutation mutation) throws PermanentBackendException {
        StringBuilder script = new StringBuilder();
        for (IndexEntry deletion : mutation.getDeletions()) {
            KeyInformation keyInformation = informations.get(storename).get(deletion.field);
            switch (keyInformation.getCardinality()) {
                case SINGLE: {
                    script.append("ctx._source.remove(\"" + deletion.field + "\");");
                    if (!ElasticSearchIndex.hasDualStringMapping(informations.get(storename, deletion.field))) break;
                    script.append("ctx._source.remove(\"" + ElasticSearchIndex.getDualMappingName(deletion.field) + "\");");
                    break;
                }
                case SET: 
                case LIST: {
                    String jsValue = ElasticSearchIndex.convertToJsType(deletion.value);
                    script.append("def index = ctx._source[\"" + deletion.field + "\"].indexOf(" + jsValue + "); ctx._source[\"" + deletion.field + "\"].remove(index);");
                    if (!ElasticSearchIndex.hasDualStringMapping(informations.get(storename, deletion.field))) break;
                    script.append("def index = ctx._source[\"" + ElasticSearchIndex.getDualMappingName(deletion.field) + "\"].indexOf(" + jsValue + "); ctx._source[\"" + ElasticSearchIndex.getDualMappingName(deletion.field) + "\"].remove(index);");
                }
            }
        }
        return script.toString();
    }

    private String getAdditionScript(KeyInformation.IndexRetriever informations, String storename, IndexMutation mutation) throws PermanentBackendException {
        StringBuilder script = new StringBuilder();
        for (IndexEntry e : mutation.getAdditions()) {
            KeyInformation keyInformation = informations.get(storename).get(e.field);
            switch (keyInformation.getCardinality()) {
                case SINGLE: {
                    script.append("ctx._source[\"" + e.field + "\"] = " + ElasticSearchIndex.convertToJsType(e.value) + ";");
                    if (!ElasticSearchIndex.hasDualStringMapping(keyInformation)) break;
                    script.append("ctx._source[\"" + ElasticSearchIndex.getDualMappingName(e.field) + "\"] = " + ElasticSearchIndex.convertToJsType(e.value) + ";");
                    break;
                }
                case SET: 
                case LIST: {
                    script.append("if(ctx._source[\"" + e.field + "\"] == null) {ctx._source[\"" + e.field + "\"] = []};");
                    script.append("ctx._source[\"" + e.field + "\"].add(" + ElasticSearchIndex.convertToJsType(e.value) + ");");
                    if (!ElasticSearchIndex.hasDualStringMapping(keyInformation)) break;
                    script.append("if(ctx._source[\"" + ElasticSearchIndex.getDualMappingName(e.field) + "\"] == null) {ctx._source[\"" + e.field + "\"] = []};");
                    script.append("ctx._source[\"" + ElasticSearchIndex.getDualMappingName(e.field) + "\"].add(" + ElasticSearchIndex.convertToJsType(e.value) + ");");
                }
            }
        }
        return script.toString();
    }

    private static String convertToJsType(Object value) throws PermanentBackendException {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            Object esValue = ElasticSearchIndex.convertToEsType(value);
            if (esValue instanceof byte[]) {
                builder.rawField("value", (InputStream)new ByteArrayInputStream((byte[])esValue));
            } else {
                builder.field("value", esValue);
            }
            String s = builder.string();
            int prefixLength = "{\"value\":".length();
            int suffixLength = "}".length();
            String result = s.substring(prefixLength, s.length() - suffixLength);
            result = result.replace("$", "\\$");
            return result;
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not write json");
        }
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        BulkRequestBuilder bulk = this.client.prepareBulk();
        int requests = 0;
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                String store = stores.getKey();
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    long ttl;
                    String docID = entry.getKey();
                    List<IndexEntry> content = entry.getValue();
                    if (content == null || content.size() == 0) {
                        if (log.isTraceEnabled()) {
                            log.trace("Deleting entire document {}", (Object)docID);
                        }
                        bulk.add(new DeleteRequest(this.indexName, store, docID));
                        ++requests;
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Adding entire document {}", (Object)docID);
                    }
                    Preconditions.checkArgument(((ttl = (long)IndexMutation.determineTTL(content) * 1000L) >= 0L ? 1 : 0) != 0);
                    IndexRequest request = new IndexRequest(this.indexName, store, docID).source(this.getNewDocument(content, informations.get(store)));
                    if (ttl > 0L) {
                        request.ttl(ttl);
                    }
                    bulk.add(request);
                    ++requests;
                }
            }
            if (requests > 0) {
                bulk.execute().actionGet();
            }
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public QueryBuilder getFilter(Condition<?> condition, KeyInformation.StoreRetriever informations) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            TitanPredicate titanPredicate = atom.getPredicate();
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + titanPredicate));
                Cmp numRel = (Cmp)titanPredicate;
                Preconditions.checkArgument((boolean)(value instanceof Number));
                switch (numRel) {
                    case EQUAL: {
                        return QueryBuilders.matchQuery((String)key, (Object)value);
                    }
                    case NOT_EQUAL: {
                        return QueryBuilders.notQuery((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
                    }
                    case LESS_THAN: {
                        return QueryBuilders.rangeQuery((String)key).lt(value);
                    }
                    case LESS_THAN_EQUAL: {
                        return QueryBuilders.rangeQuery((String)key).lte(value);
                    }
                    case GREATER_THAN: {
                        return QueryBuilders.rangeQuery((String)key).gt(value);
                    }
                    case GREATER_THAN_EQUAL: {
                        return QueryBuilders.rangeQuery((String)key).gte(value);
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof String) {
                Mapping map = ElasticSearchIndex.getStringMapping(informations.get(key));
                String fieldName = key;
                if (map == Mapping.TEXT && !titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + titanPredicate);
                }
                if (map == Mapping.STRING && titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + titanPredicate);
                }
                if (map == Mapping.TEXTSTRING && !titanPredicate.toString().startsWith("CONTAINS")) {
                    fieldName = ElasticSearchIndex.getDualMappingName(key);
                }
                if (titanPredicate == Text.CONTAINS) {
                    value = ((String)value).toLowerCase();
                    BoolQueryBuilder b = QueryBuilders.boolQuery();
                    for (String term : Text.tokenize((String)((String)value))) {
                        b.must((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)term));
                    }
                    return b;
                }
                if (titanPredicate == Text.CONTAINS_PREFIX) {
                    value = ((String)value).toLowerCase();
                    return QueryBuilders.prefixQuery((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Text.CONTAINS_REGEX) {
                    value = ((String)value).toLowerCase();
                    return QueryBuilders.regexpQuery((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Text.PREFIX) {
                    return QueryBuilders.prefixQuery((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Text.REGEX) {
                    return QueryBuilders.regexpQuery((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Cmp.EQUAL) {
                    return QueryBuilders.termQuery((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Cmp.NOT_EQUAL) {
                    return QueryBuilders.notQuery((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)((String)value)));
                }
                throw new IllegalArgumentException("Predicate is not supported for string value: " + titanPredicate);
            }
            if (value instanceof Geoshape && Mapping.getMapping((KeyInformation)informations.get(key)) == Mapping.DEFAULT) {
                GeoPolygonQueryBuilder queryBuilder;
                Geoshape shape = (Geoshape)value;
                Preconditions.checkArgument((titanPredicate instanceof Geo && titanPredicate != Geo.CONTAINS ? 1 : 0) != 0, (Object)("Relation not supported on geopoint types: " + titanPredicate));
                if (shape.getType() == Geoshape.Type.CIRCLE) {
                    Geoshape.Point center = shape.getPoint();
                    queryBuilder = QueryBuilders.geoDistanceQuery((String)key).lat(center.getLatitude()).lon(center.getLongitude()).distance(shape.getRadius(), DistanceUnit.KILOMETERS);
                } else if (shape.getType() == Geoshape.Type.BOX) {
                    Geoshape.Point southwest = shape.getPoint(0);
                    Geoshape.Point northeast = shape.getPoint(1);
                    queryBuilder = QueryBuilders.geoBoundingBoxQuery((String)key).bottomRight(southwest.getLatitude(), northeast.getLongitude()).topLeft(northeast.getLatitude(), southwest.getLongitude());
                } else if (shape.getType() == Geoshape.Type.POLYGON) {
                    queryBuilder = QueryBuilders.geoPolygonQuery((String)key);
                    for (int i = 0; i < shape.size(); ++i) {
                        Geoshape.Point point = shape.getPoint(i);
                        queryBuilder.addPoint(point.getLatitude(), point.getLongitude());
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported or invalid search shape type for geopoint: " + shape.getType());
                }
                return titanPredicate == Geo.DISJOINT ? QueryBuilders.notQuery((QueryBuilder)queryBuilder) : queryBuilder;
            }
            if (value instanceof Geoshape) {
                PolygonBuilder sb;
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Geo), (Object)("Relation not supported on geoshape types: " + titanPredicate));
                Geoshape shape = (Geoshape)value;
                switch (shape.getType()) {
                    case CIRCLE: {
                        Geoshape.Point center = shape.getPoint();
                        sb = ShapeBuilder.newCircleBuilder().center(center.getLongitude(), center.getLatitude()).radius(shape.getRadius(), DistanceUnit.KILOMETERS);
                        break;
                    }
                    case BOX: {
                        Geoshape.Point southwest = shape.getPoint(0);
                        Geoshape.Point northeast = shape.getPoint(1);
                        sb = ShapeBuilder.newEnvelope().bottomRight(northeast.getLongitude(), southwest.getLatitude()).topLeft(southwest.getLongitude(), northeast.getLatitude());
                        break;
                    }
                    case POLYGON: {
                        sb = ShapeBuilder.newPolygon();
                        for (int i = 0; i < shape.size(); ++i) {
                            Geoshape.Point point = shape.getPoint(i);
                            sb.point(point.getLongitude(), point.getLatitude());
                        }
                        break;
                    }
                    case LINE: {
                        sb = ShapeBuilder.newLineString();
                        for (int i = 0; i < shape.size(); ++i) {
                            Geoshape.Point point = shape.getPoint(i);
                            ((LineStringBuilder)sb).point(point.getLongitude(), point.getLatitude());
                        }
                        break;
                    }
                    case POINT: {
                        sb = ShapeBuilder.newPoint((double)shape.getPoint().getLongitude(), (double)shape.getPoint().getLatitude());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported or invalid search shape type: " + shape.getType());
                    }
                }
                return QueryBuilders.geoShapeQuery((String)key, (ShapeBuilder)sb, (ShapeRelation)SPATIAL_PREDICATES.get((Geo)titanPredicate));
            }
            if (value instanceof Date || value instanceof Instant) {
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on date types: " + titanPredicate));
                Cmp numRel = (Cmp)titanPredicate;
                switch (numRel) {
                    case EQUAL: {
                        return QueryBuilders.matchQuery((String)key, (Object)value);
                    }
                    case NOT_EQUAL: {
                        return QueryBuilders.notQuery((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
                    }
                    case LESS_THAN: {
                        return QueryBuilders.rangeQuery((String)key).lt(value);
                    }
                    case LESS_THAN_EQUAL: {
                        return QueryBuilders.rangeQuery((String)key).lte(value);
                    }
                    case GREATER_THAN: {
                        return QueryBuilders.rangeQuery((String)key).gt(value);
                    }
                    case GREATER_THAN_EQUAL: {
                        return QueryBuilders.rangeQuery((String)key).gte(value);
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof Boolean) {
                Cmp numRel = (Cmp)titanPredicate;
                switch (numRel) {
                    case EQUAL: {
                        return QueryBuilders.matchQuery((String)key, (Object)value);
                    }
                    case NOT_EQUAL: {
                        return QueryBuilders.notQuery((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
                    }
                }
                throw new IllegalArgumentException("Boolean types only support EQUAL or NOT_EQUAL");
            }
            if (value instanceof UUID) {
                if (titanPredicate == Cmp.EQUAL) {
                    return QueryBuilders.termQuery((String)key, (Object)value);
                }
                if (titanPredicate == Cmp.NOT_EQUAL) {
                    return QueryBuilders.notQuery((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
                }
                throw new IllegalArgumentException("Only equal or not equal is supported for UUIDs: " + titanPredicate);
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            return QueryBuilders.notQuery((QueryBuilder)this.getFilter(((Not)condition).getChild(), informations));
        }
        if (condition instanceof And) {
            BoolQueryBuilder b = QueryBuilders.boolQuery();
            for (Condition c : condition.getChildren()) {
                b.must(this.getFilter(c, informations));
            }
            return b;
        }
        if (condition instanceof Or) {
            BoolQueryBuilder b = QueryBuilders.boolQuery();
            b.minimumNumberShouldMatch(1);
            for (Condition c : condition.getChildren()) {
                b.should(this.getFilter(c, informations));
            }
            return b;
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{this.indexName});
        srb.setTypes(new String[]{query.getStore()});
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        srb.setPostFilter(this.getFilter(query.getCondition(), informations.get(query.getStore())));
        if (!query.getOrder().isEmpty()) {
            List orders = query.getOrder();
            for (int i = 0; i < orders.size(); ++i) {
                IndexQuery.OrderEntry orderEntry = (IndexQuery.OrderEntry)orders.get(i);
                FieldSortBuilder fsb = new FieldSortBuilder(((IndexQuery.OrderEntry)orders.get(i)).getKey()).order(orderEntry.getOrder() == Order.ASC ? SortOrder.ASC : SortOrder.DESC);
                if (this.useDeprecatedIgnoreUnmapped) {
                    fsb.ignoreUnmapped(true);
                } else {
                    KeyInformation information = informations.get(query.getStore()).get(((IndexQuery.OrderEntry)orders.get(i)).getKey());
                    Mapping mapping = Mapping.getMapping((KeyInformation)information);
                    Class datatype = orderEntry.getDatatype();
                    fsb.unmappedType(this.convertToEsDataType(datatype, mapping));
                }
                srb.addSort((SortBuilder)fsb);
            }
        }
        srb.setFrom(0);
        if (query.hasLimit()) {
            srb.setSize(query.getLimit());
        } else {
            srb.setSize(this.maxResultsSize);
        }
        srb.setNoFields();
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        log.debug("Executed query [{}] in {} ms", (Object)query.getCondition(), (Object)response.getTookInMillis());
        SearchHits hits = response.getHits();
        if (!query.hasLimit() && hits.totalHits() >= (long)this.maxResultsSize) {
            log.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResultsSize, (Object)query);
        }
        ArrayList<String> result = new ArrayList<String>(hits.hits().length);
        for (SearchHit hit : hits) {
            result.add(hit.id());
        }
        return result;
    }

    private String convertToEsDataType(Class<?> datatype, Mapping mapping) {
        if (String.class.isAssignableFrom(datatype)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(datatype)) {
            return "integer";
        }
        if (Long.class.isAssignableFrom(datatype)) {
            return "long";
        }
        if (Float.class.isAssignableFrom(datatype)) {
            return "float";
        }
        if (Double.class.isAssignableFrom(datatype)) {
            return "double";
        }
        if (Boolean.class.isAssignableFrom(datatype)) {
            return "boolean";
        }
        if (Date.class.isAssignableFrom(datatype)) {
            return "date";
        }
        if (Instant.class.isAssignableFrom(datatype)) {
            return "date";
        }
        if (Geoshape.class.isAssignableFrom(datatype)) {
            return mapping == Mapping.DEFAULT ? "geo_point" : "geo_shape";
        }
        return null;
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{this.indexName});
        srb.setTypes(new String[]{query.getStore()});
        srb.setQuery((QueryBuilder)QueryBuilders.queryStringQuery((String)query.getQuery()));
        srb.setFrom(query.getOffset());
        if (query.hasLimit()) {
            srb.setSize(query.getLimit());
        } else {
            srb.setSize(this.maxResultsSize);
        }
        srb.setNoFields();
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        log.debug("Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getTookInMillis());
        SearchHits hits = response.getHits();
        if (!query.hasLimit() && hits.totalHits() >= (long)this.maxResultsSize) {
            log.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResultsSize, (Object)query);
        }
        ArrayList<RawQuery.Result<String>> result = new ArrayList<RawQuery.Result<String>>(hits.hits().length);
        for (SearchHit hit : hits) {
            result.add((RawQuery.Result<String>)new RawQuery.Result((Object)hit.id(), (double)hit.getScore()));
        }
        return result;
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (!(mapping == Mapping.DEFAULT || AttributeUtil.isString((Class)dataType) || mapping == Mapping.PREFIX_TREE && AttributeUtil.isGeo((Class)dataType))) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            if (titanPredicate instanceof Cmp) {
                return true;
            }
        } else if (dataType == Geoshape.class) {
            switch (mapping) {
                case DEFAULT: {
                    return titanPredicate instanceof Geo && titanPredicate != Geo.CONTAINS;
                }
                case PREFIX_TREE: {
                    return titanPredicate instanceof Geo;
                }
            }
        } else if (AttributeUtil.isString((Class)dataType)) {
            switch (mapping) {
                case TEXT: 
                case DEFAULT: {
                    return titanPredicate == Text.CONTAINS || titanPredicate == Text.CONTAINS_PREFIX || titanPredicate == Text.CONTAINS_REGEX;
                }
                case STRING: {
                    return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL || titanPredicate == Text.REGEX || titanPredicate == Text.PREFIX;
                }
                case TEXTSTRING: {
                    return titanPredicate instanceof Text || titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL;
                }
            }
        } else if (dataType == Date.class || dataType == Instant.class) {
            if (titanPredicate instanceof Cmp) {
                return true;
            }
        } else {
            if (dataType == Boolean.class) {
                return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL;
            }
            if (dataType == UUID.class) {
                return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL;
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        return Number.class.isAssignableFrom(dataType) || dataType == Date.class || dataType == Instant.class || dataType == Boolean.class || dataType == UUID.class ? mapping == Mapping.DEFAULT : (AttributeUtil.isString((Class)dataType) ? mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT || mapping == Mapping.TEXTSTRING : AttributeUtil.isGeo((Class)dataType) && (mapping == Mapping.DEFAULT || mapping == Mapping.PREFIX_TREE));
    }

    public String mapKey2Field(String key, KeyInformation information) {
        Preconditions.checkArgument((!StringUtils.containsAny((String)key, (char[])new char[]{' '}) ? 1 : 0) != 0, (String)"Invalid key name provided: %s", (Object[])new Object[]{key});
        return key;
    }

    public IndexFeatures getFeatures() {
        return ES_FEATURES;
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new DefaultTransaction(config);
    }

    public void close() throws BackendException {
        if (this.node != null && !this.node.isClosed()) {
            this.node.close();
        }
        this.client.close();
    }

    public void clearStorage() throws BackendException {
        try {
            try {
                this.client.admin().indices().delete(new DeleteIndexRequest(this.indexName)).actionGet();
                Thread.sleep(1000L);
            }
            catch (IndexNotFoundException indexNotFoundException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            throw new PermanentBackendException("Could not delete index " + this.indexName, (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    Node getNode() {
        return this.node;
    }

    private void checkExpectedClientVersion() {
        try {
            if (!Version.CURRENT.toString().equals(ElasticSearchConstants.ES_VERSION_EXPECTED)) {
                log.warn("ES client version ({}) does not match the version with which Titan was compiled ({}).  This might cause problems.", (Object)Version.CURRENT, (Object)ElasticSearchConstants.ES_VERSION_EXPECTED);
            } else {
                log.debug("Found ES client version matching Titan's compile-time version: {} (OK)", (Object)Version.CURRENT);
            }
        }
        catch (RuntimeException e) {
            log.warn("Unable to check expected ES client version", (Throwable)e);
        }
    }
}

