/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.CommonsConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.graphdb.olap.job.IndexRemoveJob;
import com.thinkaurelius.titan.graphdb.olap.job.IndexRepairJob;
import com.thinkaurelius.titan.graphdb.olap.job.IndexUpdateJob;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.scan.CassandraHadoopScanRunner;
import com.thinkaurelius.titan.hadoop.scan.HBaseHadoopScanRunner;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.BaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceIndexJobs {
    private static final Logger log = LoggerFactory.getLogger(MapReduceIndexJobs.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics cassandraRepair(String titanPropertiesPath, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(titanPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.cassandraRepair(p, indexName, relationType, partitionerName);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics cassandraRepair(Properties titanProperties, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.cassandraRepair(titanProperties, indexName, relationType, partitionerName, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics cassandraRepair(Properties titanProperties, String indexName, String relationType, String partitionerName, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRepairJob job = new IndexRepairJob();
        CassandraHadoopScanRunner cr = new CassandraHadoopScanRunner((VertexScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, titanProperties);
        cr.partitionerOverride(partitionerName);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics cassandraRemove(String titanPropertiesPath, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(titanPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.cassandraRemove(p, indexName, relationType, partitionerName);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics cassandraRemove(Properties titanProperties, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.cassandraRemove(titanProperties, indexName, relationType, partitionerName, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics cassandraRemove(Properties titanProperties, String indexName, String relationType, String partitionerName, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRemoveJob job = new IndexRemoveJob();
        CassandraHadoopScanRunner cr = new CassandraHadoopScanRunner((ScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, titanProperties);
        cr.partitionerOverride(partitionerName);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics hbaseRepair(String titanPropertiesPath, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(titanPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.hbaseRepair(p, indexName, relationType);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics hbaseRepair(Properties titanProperties, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.hbaseRepair(titanProperties, indexName, relationType, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics hbaseRepair(Properties titanProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRepairJob job = new IndexRepairJob();
        HBaseHadoopScanRunner cr = new HBaseHadoopScanRunner((VertexScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, titanProperties);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics hbaseRemove(String titanPropertiesPath, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(titanPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.hbaseRemove(p, indexName, relationType);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics hbaseRemove(Properties titanProperties, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.hbaseRemove(titanProperties, indexName, relationType, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics hbaseRemove(Properties titanProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRemoveJob job = new IndexRemoveJob();
        HBaseHadoopScanRunner cr = new HBaseHadoopScanRunner((ScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, titanProperties);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    private static ModifiableConfiguration getIndexJobConf(String indexName, String relationType) {
        ModifiableConfiguration mc = new ModifiableConfiguration(GraphDatabaseConfiguration.JOB_NS, (WriteConfiguration)new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
        mc.set(IndexUpdateJob.INDEX_NAME, (Object)indexName, new String[0]);
        mc.set(IndexUpdateJob.INDEX_RELATION_TYPE, (Object)relationType, new String[0]);
        mc.set(GraphDatabaseConfiguration.JOB_START_TIME, (Object)System.currentTimeMillis(), new String[0]);
        return mc;
    }

    private static void copyPropertiesToInputAndOutputConf(org.apache.hadoop.conf.Configuration sink, Properties source) {
        String prefix = ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            String v = e.getValue().toString();
            String k = prefix + e.getKey().toString();
            sink.set(k, v);
            log.info("Set {}={}", (Object)k, (Object)v);
        }
    }
}

