/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.util.time.Durations;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfiguration
implements WriteConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HadoopConfiguration.class);
    private final Configuration config;
    private final String prefix;

    public HadoopConfiguration(Configuration config) {
        this(config, null);
    }

    public HadoopConfiguration(Configuration config, String prefix) {
        this.config = config;
        this.prefix = prefix;
    }

    public <O> O get(String key, Class<O> datatype) {
        String internalKey = this.getInternalKey(key);
        if (null == this.config.get(internalKey)) {
            return null;
        }
        if (datatype.isArray()) {
            Preconditions.checkArgument((datatype.getComponentType() == String.class ? 1 : 0) != 0, (String)"Only string arrays are supported: %s", (Object[])new Object[]{datatype});
            return (O)this.config.getStrings(internalKey);
        }
        if (Number.class.isAssignableFrom(datatype)) {
            String s = this.config.get(internalKey);
            return this.constructFromStringArgument(datatype, s);
        }
        if (datatype == String.class) {
            return (O)this.config.get(internalKey);
        }
        if (datatype == Boolean.class) {
            return (O)Boolean.valueOf(this.config.get(internalKey));
        }
        if (datatype.isEnum()) {
            O[] constants = datatype.getEnumConstants();
            Preconditions.checkState((null != constants && 0 < constants.length ? 1 : 0) != 0, (Object)"Zero-length or undefined enum");
            String estr = this.config.get(internalKey);
            for (O c : constants) {
                if (!c.toString().equals(estr)) continue;
                return c;
            }
            throw new IllegalArgumentException("No match for string \"" + estr + "\" in enum " + datatype);
        }
        if (datatype == Object.class) {
            return (O)this.config.get(internalKey);
        }
        if (Duration.class.isAssignableFrom(datatype)) {
            String s = this.config.get(internalKey);
            String[] comps = s.split("\\s");
            TemporalUnit unit = null;
            if (comps.length == 1) {
                unit = ChronoUnit.MILLIS;
            } else if (comps.length == 2) {
                unit = Durations.parse((String)comps[1]);
            } else {
                throw new IllegalArgumentException("Cannot parse time duration from: " + s);
            }
            return (O)Duration.of(Long.valueOf(comps[0]), unit);
        }
        throw new IllegalArgumentException("Unsupported data type: " + datatype);
    }

    public Iterable<String> getKeys(final String userPrefix) {
        Iterable internalKeys = Iterables.transform((Iterable)this.config, (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> internalEntry) {
                return internalEntry.getKey();
            }
        });
        Iterable prefixedKeys = Iterables.filter((Iterable)internalKeys, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String internalKey) {
                String k = internalKey;
                if (null != HadoopConfiguration.this.prefix) {
                    if (k.startsWith(HadoopConfiguration.this.prefix)) {
                        k = HadoopConfiguration.this.getUserKey(k);
                    } else {
                        return false;
                    }
                }
                return k.startsWith(userPrefix);
            }
        });
        return Iterables.transform((Iterable)prefixedKeys, (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String internalKey) {
                String userKey = HadoopConfiguration.this.getUserKey(internalKey);
                Preconditions.checkState((boolean)userKey.startsWith(userPrefix));
                return userKey;
            }
        });
    }

    public void close() {
    }

    public <O> void set(String key, O value) {
        String internalKey = this.getInternalKey(key);
        Class<?> datatype = value.getClass();
        if (datatype.isArray()) {
            Preconditions.checkArgument((datatype.getComponentType() == String.class ? 1 : 0) != 0, (String)"Only string arrays are supported: %s", (Object[])new Object[]{datatype});
            this.config.setStrings(internalKey, (String[])value);
        } else if (Number.class.isAssignableFrom(datatype)) {
            this.config.set(internalKey, value.toString());
        } else if (datatype == String.class) {
            this.config.set(internalKey, value.toString());
        } else if (datatype == Boolean.class) {
            this.config.setBoolean(internalKey, ((Boolean)value).booleanValue());
        } else if (datatype.isEnum()) {
            this.config.set(internalKey, value.toString());
        } else if (datatype == Object.class) {
            this.config.set(internalKey, value.toString());
        } else if (Duration.class.isAssignableFrom(datatype)) {
            String millis = String.valueOf(((Duration)value).toMillis());
            this.config.set(internalKey, millis);
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + datatype);
        }
    }

    public void remove(String key) {
        this.config.unset(this.getInternalKey(key));
    }

    public WriteConfiguration copy() {
        return new HadoopConfiguration(new Configuration(this.config), this.prefix);
    }

    private <O> O constructFromStringArgument(Class<O> datatype, String arg) {
        try {
            Constructor<O> ctor = datatype.getConstructor(String.class);
            return ctor.newInstance(arg);
        }
        catch (Exception e) {
            log.error("Failed to parse configuration string \"{}\" into type {} due to the following reflection exception", new Object[]{arg, datatype, e});
            throw new RuntimeException(e);
        }
    }

    private String getInternalKey(String userKey) {
        return null == this.prefix ? userKey : this.prefix + userKey;
    }

    private String getUserKey(String internalKey) {
        String k = internalKey;
        if (null != this.prefix) {
            Preconditions.checkState((boolean)k.startsWith(this.prefix), (String)"key %s does not start with prefix %s", (Object[])new Object[]{internalKey, this.prefix});
            Preconditions.checkState((internalKey.length() > this.prefix.length() ? 1 : 0) != 0);
            k = internalKey.substring(this.prefix.length());
        }
        return k;
    }
}

