/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util.input.current;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.graphdb.database.RelationReader;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.input.SystemTypeInspector;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetupCommon;
import org.apache.hadoop.conf.Configuration;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class TitanHadoopSetupImpl
extends TitanHadoopSetupCommon {
    private final ModifiableHadoopConfiguration scanConf;
    private final StandardTitanGraph graph;
    private final StandardTitanTx tx;

    public TitanHadoopSetupImpl(Configuration config) {
        this.scanConf = ModifiableHadoopConfiguration.of(TitanHadoopConfiguration.MAPRED_NS, config);
        ModifiableConfiguration bc = this.scanConf.getTitanGraphConf();
        this.graph = (StandardTitanGraph)TitanFactory.open((BasicConfiguration)bc);
        this.tx = (StandardTitanTx)this.graph.buildTransaction().readOnly().vertexCacheSize(200).start();
    }

    @Override
    public TypeInspector getTypeInspector() {
        for (TitanSchemaCategory sc : TitanSchemaCategory.values()) {
            for (TitanVertex k : QueryUtil.getVertices((StandardTitanTx)this.tx, (PropertyKey)BaseKey.SchemaCategory, (Object)sc)) {
                assert (k instanceof TitanSchemaVertex);
                TitanSchemaVertex s = (TitanSchemaVertex)k;
                if (sc.hasName()) {
                    String name = s.name();
                    Preconditions.checkNotNull((Object)name);
                }
                TypeDefinitionMap dm = s.getDefinition();
                Preconditions.checkNotNull((Object)dm);
                s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT);
                s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.IN);
            }
        }
        return this.tx;
    }

    @Override
    public SystemTypeInspector getSystemTypeInspector() {
        return new SystemTypeInspector(){

            @Override
            public boolean isSystemType(long typeid) {
                return IDManager.isSystemRelationTypeId((long)typeid);
            }

            @Override
            public boolean isVertexExistsSystemType(long typeid) {
                return typeid == BaseKey.VertexExists.longId();
            }

            @Override
            public boolean isVertexLabelSystemType(long typeid) {
                return typeid == BaseLabel.VertexLabelEdge.longId();
            }

            @Override
            public boolean isTypeSystemType(long typeid) {
                return typeid == BaseKey.SchemaCategory.longId() || typeid == BaseKey.SchemaDefinitionProperty.longId() || typeid == BaseKey.SchemaDefinitionDesc.longId() || typeid == BaseKey.SchemaName.longId() || typeid == BaseLabel.SchemaDefinitionEdge.longId();
            }
        };
    }

    @Override
    public IDManager getIDManager() {
        return this.graph.getIDManager();
    }

    @Override
    public RelationReader getRelationReader(long vertexid) {
        return this.graph.getEdgeSerializer();
    }

    @Override
    public void close() {
        this.tx.rollback();
        this.graph.close();
    }

    @Override
    public boolean getFilterPartitionedVertices() {
        return (Boolean)this.scanConf.get(TitanHadoopConfiguration.FILTER_PARTITIONED_VERTICES, new String[0]);
    }
}

