/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.scan;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.hbase.HBaseBinaryInputFormat;
import com.thinkaurelius.titan.hadoop.scan.AbstractHadoopScanRunner;
import com.thinkaurelius.titan.hadoop.scan.HadoopScanRunner;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHadoopScanRunner
extends AbstractHadoopScanRunner<HBaseHadoopScanRunner> {
    private static final Logger log = LoggerFactory.getLogger(HBaseHadoopScanRunner.class);

    public HBaseHadoopScanRunner(ScanJob scanJob) {
        super(scanJob);
    }

    public HBaseHadoopScanRunner(VertexScanJob vertexScanJob) {
        super(vertexScanJob);
    }

    @Override
    protected HBaseHadoopScanRunner self() {
        return this;
    }

    public ScanMetrics run() throws InterruptedException, IOException, ClassNotFoundException {
        Configuration hadoopConf;
        Configuration configuration = hadoopConf = null != this.baseHadoopConf ? this.baseHadoopConf : new Configuration();
        if (null != this.titanConf) {
            String prefix = ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
            for (String k : this.titanConf.getKeys("")) {
                hadoopConf.set(prefix + k, this.titanConf.get(k, Object.class).toString());
                log.debug("Set: {}={}", (Object)(prefix + k), (Object)this.titanConf.get(k, Object.class).toString());
            }
        }
        Preconditions.checkNotNull((Object)hadoopConf);
        if (null != this.scanJob) {
            return HadoopScanRunner.runScanJob(this.scanJob, this.scanJobConf, this.scanJobConfRoot, hadoopConf, HBaseBinaryInputFormat.class);
        }
        return HadoopScanRunner.runVertexScanJob(this.vertexScanJob, this.scanJobConf, this.scanJobConfRoot, hadoopConf, HBaseBinaryInputFormat.class);
    }
}

