/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.TitanH1OutputCommitter;
import com.thinkaurelius.titan.hadoop.formats.TitanH1RecordWriter;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanH1OutputFormat
extends OutputFormat<NullWritable, VertexWritable> {
    private static final Logger log = LoggerFactory.getLogger(TitanH1OutputFormat.class);
    private final ConcurrentMap<TaskAttemptID, StandardTitanTx> transactions = new ConcurrentHashMap<TaskAttemptID, StandardTitanTx>();
    private StandardTitanGraph graph;
    private Set<String> persistableKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordWriter<NullWritable, VertexWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        TitanH1OutputFormat titanH1OutputFormat = this;
        synchronized (titanH1OutputFormat) {
            if (null == this.graph) {
                org.apache.hadoop.conf.Configuration hadoopConf = taskAttemptContext.getConfiguration();
                ModifiableHadoopConfiguration mhc = ModifiableHadoopConfiguration.of(TitanHadoopConfiguration.MAPRED_NS, hadoopConf);
                this.graph = (StandardTitanGraph)TitanFactory.open((BasicConfiguration)mhc.getTitanGraphConf());
            }
        }
        if (null == this.persistableKeys) {
            try {
                this.persistableKeys = VertexProgram.createVertexProgram((Graph)this.graph, (Configuration)ConfUtil.makeApacheConfiguration((org.apache.hadoop.conf.Configuration)taskAttemptContext.getConfiguration())).getElementComputeKeys();
                log.debug("Set persistableKeys={}", (Object)Joiner.on((String)",").join(this.persistableKeys));
            }
            catch (Exception e) {
                log.debug("Unable to detect or instantiate vertex program", (Throwable)e);
                this.persistableKeys = ImmutableSet.of();
            }
        }
        StandardTitanTx tx = this.transactions.computeIfAbsent(taskAttemptContext.getTaskAttemptID(), id -> (StandardTitanTx)this.graph.newTransaction());
        return new TitanH1RecordWriter(taskAttemptContext, tx, this.persistableKeys);
    }

    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new TitanH1OutputCommitter(this);
    }

    void commit(TaskAttemptID id) {
        StandardTitanTx tx = (StandardTitanTx)this.transactions.remove(id);
        if (null == tx) {
            log.warn("Detected concurrency in task commit");
            return;
        }
        tx.commit();
    }

    void abort(TaskAttemptID id) {
        StandardTitanTx tx = (StandardTitanTx)this.transactions.remove(id);
        if (null == tx) {
            log.warn("Detected concurrency in task abort");
            return;
        }
        tx.rollback();
    }

    boolean hasModifications(TaskAttemptID id) {
        StandardTitanTx tx = (StandardTitanTx)this.transactions.get(id);
        return tx.hasModifications();
    }
}

