/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.hbase;

import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.hbase.HBaseBinaryRecordReader;
import com.thinkaurelius.titan.hadoop.formats.util.AbstractBinaryInputFormat;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseBinaryInputFormat
extends AbstractBinaryInputFormat {
    private static final Logger log = LoggerFactory.getLogger(HBaseBinaryInputFormat.class);
    private final TableInputFormat tableInputFormat = new TableInputFormat();
    private RecordReader<ImmutableBytesWritable, Result> tableReader;
    private byte[] inputCFBytes;
    private RecordReader<StaticBuffer, Iterable<Entry>> titanRecordReader;

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.tableInputFormat.getSplits(jobContext);
    }

    public RecordReader<StaticBuffer, Iterable<Entry>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.tableReader = this.tableInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        this.titanRecordReader = new HBaseBinaryRecordReader(this.tableReader, this.inputCFBytes);
        return this.titanRecordReader;
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        config.set("hbase.mapreduce.inputtable", (String)this.titanConf.get(HBaseStoreManager.HBASE_TABLE, new String[0]));
        config.set("hbase.zookeeper.quorum", ((String[])this.titanConf.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]))[0]);
        if (this.titanConf.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            config.set("hbase.zookeeper.property.clientPort", String.valueOf(this.titanConf.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])));
        }
        config.set("autotype", "none");
        log.debug("hbase.security.authentication={}", (Object)config.get("hbase.security.authentication"));
        Scan scanner = new Scan();
        String cfName = (String)this.mrConf.get(TitanHadoopConfiguration.COLUMN_FAMILY_NAME, new String[0]);
        if (((Boolean)this.titanConf.get(HBaseStoreManager.SHORT_CF_NAMES, new String[0])).booleanValue()) {
            try {
                cfName = HBaseStoreManager.shortenCfName((String)cfName);
            }
            catch (PermanentBackendException e) {
                throw new RuntimeException(e);
            }
        }
        scanner.addFamily(cfName.getBytes());
        this.inputCFBytes = Bytes.toBytes((String)cfName);
        try {
            Method converter = TableMapReduceUtil.class.getDeclaredMethod("convertScanToString", Scan.class);
            converter.setAccessible(true);
            config.set("hbase.mapreduce.scan", (String)converter.invoke(null, scanner));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tableInputFormat.setConf(config);
    }

    public RecordReader<ImmutableBytesWritable, Result> getTableReader() {
        return this.tableReader;
    }

    public byte[] getEdgeStoreFamily() {
        return this.inputCFBytes;
    }

    private Filter getColumnFilter(SliceQuery query) {
        return null;
    }

    @Override
    public Configuration getConf() {
        return this.tableInputFormat.getConf();
    }
}

