/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.scan;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.cassandra.CassandraBinaryInputFormat;
import com.thinkaurelius.titan.hadoop.scan.AbstractHadoopScanRunner;
import com.thinkaurelius.titan.hadoop.scan.HadoopScanRunner;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHadoopScanRunner
extends AbstractHadoopScanRunner<CassandraHadoopScanRunner> {
    private static final Logger log = LoggerFactory.getLogger(CassandraHadoopScanRunner.class);
    private static final String CASSANDRA_PARTITIONER_KEY = "cassandra.input.partitioner.class";
    private String partitionerOverride;

    public CassandraHadoopScanRunner(ScanJob scanJob) {
        super(scanJob);
    }

    public CassandraHadoopScanRunner(VertexScanJob vertexScanJob) {
        super(vertexScanJob);
    }

    @Override
    protected CassandraHadoopScanRunner self() {
        return this;
    }

    public CassandraHadoopScanRunner partitionerOverride(String partitionerOverride) {
        this.partitionerOverride = partitionerOverride;
        return this;
    }

    public ScanMetrics run() throws InterruptedException, IOException, ClassNotFoundException {
        Configuration hadoopConf;
        Configuration configuration = hadoopConf = null != this.baseHadoopConf ? this.baseHadoopConf : new Configuration();
        if (null != this.titanConf) {
            for (String k : this.titanConf.getKeys("")) {
                String prefix = ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
                hadoopConf.set(prefix + k, this.titanConf.get(k, Object.class).toString());
                log.debug("Set: {}={}", (Object)(prefix + k), (Object)this.titanConf.get(k, Object.class).toString());
            }
        }
        if (null != this.partitionerOverride) {
            hadoopConf.set(CASSANDRA_PARTITIONER_KEY, this.partitionerOverride);
        }
        if (null == hadoopConf.get(CASSANDRA_PARTITIONER_KEY)) {
            throw new IllegalArgumentException("cassandra.input.partitioner.class must be provided in either the base Hadoop Configuration object or by the partitionerOverride method");
        }
        log.debug("Partitioner: {}={}", (Object)CASSANDRA_PARTITIONER_KEY, (Object)hadoopConf.get(CASSANDRA_PARTITIONER_KEY));
        Preconditions.checkNotNull((Object)hadoopConf);
        if (null != this.scanJob) {
            return HadoopScanRunner.runScanJob(this.scanJob, this.scanJobConf, this.scanJobConfRoot, hadoopConf, CassandraBinaryInputFormat.class);
        }
        return HadoopScanRunner.runVertexScanJob(this.vertexScanJob, this.scanJobConf, this.scanJobConfRoot, hadoopConf, CassandraBinaryInputFormat.class);
    }
}

