/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.config;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.hadoop.config.HadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import org.apache.hadoop.conf.Configuration;

public class ModifiableHadoopConfiguration
extends ModifiableConfiguration {
    private final Configuration conf;

    private ModifiableHadoopConfiguration(ConfigNamespace root, Configuration c, BasicConfiguration.Restriction restriction) {
        super(root, (WriteConfiguration)new HadoopConfiguration(c), restriction);
        this.conf = c;
    }

    public static ModifiableHadoopConfiguration of(ConfigNamespace root, Configuration c) {
        Preconditions.checkNotNull((Object)c);
        return new ModifiableHadoopConfiguration(root, c, BasicConfiguration.Restriction.NONE);
    }

    public static ModifiableConfiguration prefixView(ConfigNamespace newRoot, ConfigNamespace prefixRoot, ModifiableHadoopConfiguration mc) {
        HadoopConfiguration prefixConf = new HadoopConfiguration(mc.getHadoopConfiguration(), ConfigElement.getPath((ConfigElement)prefixRoot, (boolean)true, (String[])new String[0]) + ".");
        return new ModifiableConfiguration(newRoot, (WriteConfiguration)prefixConf, BasicConfiguration.Restriction.NONE);
    }

    public Configuration getHadoopConfiguration() {
        return this.conf;
    }

    public ModifiableConfiguration getTitanGraphConf() {
        return ModifiableHadoopConfiguration.prefixView(GraphDatabaseConfiguration.ROOT_NS, TitanHadoopConfiguration.GRAPH_CONFIG_KEYS, this);
    }
}

