/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.cassandra;

import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.cassandra.CassandraBinaryRecordReader;
import com.thinkaurelius.titan.hadoop.formats.util.AbstractBinaryInputFormat;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetupCommon;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraBinaryInputFormat
extends AbstractBinaryInputFormat {
    private static final Logger log = LoggerFactory.getLogger(CassandraBinaryInputFormat.class);
    private static final String INPUT_WIDEROWS_CONFIG = "cassandra.input.widerows";
    private static final String RANGE_BATCH_SIZE_CONFIG = "cassandra.range.batch.size";
    private final ColumnFamilyInputFormat columnFamilyInputFormat = new ColumnFamilyInputFormat();
    private ColumnFamilyRecordReader columnFamilyRecordReader;
    private RecordReader<StaticBuffer, Iterable<Entry>> titanRecordReader;

    public RecordReader<StaticBuffer, Iterable<Entry>> getRecordReader() {
        return this.titanRecordReader;
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.columnFamilyInputFormat.getSplits(jobContext);
    }

    public RecordReader<StaticBuffer, Iterable<Entry>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.columnFamilyRecordReader = (ColumnFamilyRecordReader)this.columnFamilyInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        this.titanRecordReader = new CassandraBinaryRecordReader(this.columnFamilyRecordReader);
        return this.titanRecordReader;
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        ConfigHelper.setInputInitialAddress((Configuration)config, (String)((String[])this.titanConf.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]))[0]);
        if (this.titanConf.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            ConfigHelper.setInputRpcPort((Configuration)config, (String)String.valueOf(this.titanConf.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])));
        }
        if (this.titanConf.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])) {
            ConfigHelper.setInputKeyspaceUserName((Configuration)config, (String)((String)this.titanConf.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])));
        }
        if (this.titanConf.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])) {
            ConfigHelper.setInputKeyspacePassword((Configuration)config, (String)((String)this.titanConf.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])));
        }
        boolean wideRows = config.getBoolean(INPUT_WIDEROWS_CONFIG, false);
        ConfigHelper.setInputColumnFamily((Configuration)config, (String)((String)this.titanConf.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0])), (String)((String)this.mrConf.get(TitanHadoopConfiguration.COLUMN_FAMILY_NAME, new String[0])), (boolean)wideRows);
        log.debug("Set keyspace: {}", this.titanConf.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0]));
        SlicePredicate predicate = new SlicePredicate();
        int rangeBatchSize = config.getInt(RANGE_BATCH_SIZE_CONFIG, Integer.MAX_VALUE);
        predicate.setSlice_range(this.getSliceRange(TitanHadoopSetupCommon.DEFAULT_SLICE_QUERY, rangeBatchSize));
        ConfigHelper.setInputSlicePredicate((Configuration)config, (SlicePredicate)predicate);
    }

    private SliceRange getSliceRange(SliceQuery slice, int limit) {
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(slice.getSliceStart().asByteBuffer());
        sliceRange.setFinish(slice.getSliceEnd().asByteBuffer());
        sliceRange.setCount(Math.min(limit, slice.getLimit()));
        return sliceRange;
    }
}

