/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.hadoop.formats.util.GiraphInputFormat;
import com.thinkaurelius.titan.hadoop.formats.util.TitanVertexDeserializer;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GiraphRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private static final Logger log = LoggerFactory.getLogger(GiraphRecordReader.class);
    private RecordReader<StaticBuffer, Iterable<Entry>> reader;
    private GiraphInputFormat.RefCountedCloseable countedDeser;
    private TitanVertexDeserializer deser;
    private VertexWritable vertex;

    public GiraphRecordReader(GiraphInputFormat.RefCountedCloseable<TitanVertexDeserializer> countedDeser, RecordReader<StaticBuffer, Iterable<Entry>> reader) {
        this.countedDeser = countedDeser;
        this.reader = reader;
        this.deser = countedDeser.acquire();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader.initialize(inputSplit, taskAttemptContext);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            TinkerVertex maybeNullTinkerVertex = this.deser.readHadoopVertex((StaticBuffer)this.reader.getCurrentKey(), (Iterable)this.reader.getCurrentValue());
            if (null == maybeNullTinkerVertex) continue;
            this.vertex = new VertexWritable((Vertex)maybeNullTinkerVertex);
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() throws IOException, InterruptedException {
        return this.vertex;
    }

    public void close() throws IOException {
        try {
            this.deser = null;
            this.countedDeser.release();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.reader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.reader.getProgress();
    }
}

