/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.graphdb.database.RelationReader;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.hadoop.formats.util.input.SystemTypeInspector;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetup;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanVertexDeserializer
implements AutoCloseable {
    private final TitanHadoopSetup setup;
    private final TypeInspector typeManager;
    private final SystemTypeInspector systemTypes;
    private final IDManager idManager;
    private final boolean verifyVertexExistence = false;
    private static final Logger log = LoggerFactory.getLogger(TitanVertexDeserializer.class);

    public TitanVertexDeserializer(TitanHadoopSetup setup) {
        this.setup = setup;
        this.typeManager = setup.getTypeInspector();
        this.systemTypes = setup.getSystemTypeInspector();
        this.idManager = setup.getIDManager();
    }

    private static Boolean isLoopAdded(Vertex vertex, String label) {
        Iterator adjacentVertices = vertex.vertices(Direction.BOTH, new String[]{label});
        while (adjacentVertices.hasNext()) {
            Vertex adjacentVertex = (Vertex)adjacentVertices.next();
            if (!adjacentVertex.equals(vertex)) continue;
            return true;
        }
        return false;
    }

    public TinkerVertex readHadoopVertex(StaticBuffer key, Iterable<Entry> entries) {
        RelationCache relation;
        RelationReader relationReader;
        long vertexId = this.idManager.getKeyID(key);
        Preconditions.checkArgument((vertexId > 0L ? 1 : 0) != 0);
        if (this.idManager.isPartitionedVertex(vertexId)) {
            Preconditions.checkState((boolean)this.setup.getFilterPartitionedVertices(), (String)"Read partitioned vertex (ID=%s), but partitioned vertex filtering is disabled.", (Object[])new Object[]{vertexId});
            log.debug("Skipping partitioned vertex with ID {}", (Object)vertexId);
            return null;
        }
        TinkerGraph tg = TinkerGraph.open();
        boolean foundVertexState = true;
        TinkerVertex tv = null;
        for (Entry data : entries) {
            relationReader = this.setup.getRelationReader(vertexId);
            relation = relationReader.parseRelation(data, false, this.typeManager);
            if (!this.systemTypes.isVertexLabelSystemType(relation.typeId)) continue;
            long vertexLabelId = relation.getOtherVertexId();
            VertexLabel vl = this.typeManager.getExistingVertexLabel(vertexLabelId);
            tv = this.getOrCreateVertex(vertexId, vl.name(), tg);
        }
        if (null == tv) {
            tv = this.getOrCreateVertex(vertexId, null, tg);
        }
        Preconditions.checkState((null != tv ? 1 : 0) != 0, (String)"Unable to determine vertex label for vertex with ID %s", (Object[])new Object[]{vertexId});
        for (Entry data : entries) {
            try {
                TinkerEdge te;
                RelationType type;
                relationReader = this.setup.getRelationReader(vertexId);
                relation = relationReader.parseRelation(data, false, this.typeManager);
                if (this.systemTypes.isVertexExistsSystemType(relation.typeId)) {
                    foundVertexState = true;
                }
                if (this.systemTypes.isSystemType(relation.typeId) || ((InternalRelationType)(type = this.typeManager.getExistingRelationType(relation.typeId))).isInvisibleType()) continue;
                if (type.isPropertyKey()) {
                    Object value = relation.getValue();
                    Preconditions.checkNotNull((Object)value);
                    VertexProperty.Cardinality card = this.getPropertyKeyCardinality(type.name());
                    tv.property(card, type.name(), value, new Object[]{T.id, relation.relationId});
                    continue;
                }
                assert (type.isEdgeLabel());
                if (this.idManager.isPartitionedVertex(relation.getOtherVertexId().longValue())) {
                    Preconditions.checkState((boolean)this.setup.getFilterPartitionedVertices(), (String)"Read edge incident on a partitioned vertex, but partitioned vertex filtering is disabled.  Relation ID: %s.  This vertex ID: %s.  Other vertex ID: %s.  Edge label: %s.", (Object[])new Object[]{relation.relationId, vertexId, relation.getOtherVertexId(), type.name()});
                    log.debug("Skipping edge with ID {} incident on partitioned vertex with ID {} (and nonpartitioned vertex with ID {})", new Object[]{relation.relationId, relation.getOtherVertexId(), vertexId});
                    continue;
                }
                TinkerVertex adjacentVertex = this.getOrCreateVertex(relation.getOtherVertexId(), null, tg);
                if (tv.equals((Object)adjacentVertex) && TitanVertexDeserializer.isLoopAdded((Vertex)tv, type.name()).booleanValue()) continue;
                if (relation.direction.equals((Object)Direction.IN)) {
                    te = (TinkerEdge)adjacentVertex.addEdge(type.name(), (Vertex)tv, new Object[]{T.id, relation.relationId});
                } else if (relation.direction.equals((Object)Direction.OUT)) {
                    te = (TinkerEdge)tv.addEdge(type.name(), (Vertex)adjacentVertex, new Object[]{T.id, relation.relationId});
                } else {
                    throw new RuntimeException("Direction.BOTH is not supported");
                }
                if (!relation.hasProperties()) continue;
                for (LongObjectCursor next : relation) {
                    assert (next.value != null);
                    RelationType rt = this.typeManager.getExistingRelationType(next.key);
                    if (rt.isPropertyKey()) {
                        te.property(rt.name(), next.value);
                        continue;
                    }
                    throw new RuntimeException("Metaedges are not supported");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!foundVertexState) {
            log.trace("Vertex {} has unknown lifecycle state", (Object)vertexId);
            return null;
        }
        if (!tv.edges(Direction.BOTH, new String[0]).hasNext() && !tv.properties(new String[0]).hasNext()) {
            log.trace("Vertex {} has no relations", (Object)vertexId);
            return null;
        }
        return tv;
    }

    public TinkerVertex getOrCreateVertex(long vertexId, String label, TinkerGraph tg) {
        TinkerVertex v;
        try {
            v = (TinkerVertex)tg.vertices(new Object[]{vertexId}).next();
        }
        catch (NoSuchElementException e) {
            v = null != label ? (TinkerVertex)tg.addVertex(new Object[]{T.label, label, T.id, vertexId}) : (TinkerVertex)tg.addVertex(new Object[]{T.id, vertexId});
        }
        return v;
    }

    private VertexProperty.Cardinality getPropertyKeyCardinality(String name) {
        RelationType rt = this.typeManager.getRelationType(name);
        if (null == rt || !rt.isPropertyKey()) {
            return VertexProperty.Cardinality.single;
        }
        PropertyKey pk = this.typeManager.getExistingPropertyKey(rt.longId());
        switch (pk.cardinality()) {
            case SINGLE: {
                return VertexProperty.Cardinality.single;
            }
            case LIST: {
                return VertexProperty.Cardinality.list;
            }
            case SET: {
                return VertexProperty.Cardinality.set;
            }
        }
        throw new IllegalStateException("Unknown cardinality " + pk.cardinality());
    }

    @Override
    public void close() {
        this.setup.close();
    }
}

