/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.scan;

import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.graphdb.olap.VertexJobConverter;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.scan.HadoopContextScanMetrics;
import com.thinkaurelius.titan.hadoop.scan.HadoopScanMapper;
import java.io.IOException;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class HadoopVertexScanMapper
extends HadoopScanMapper {
    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
        ModifiableHadoopConfiguration scanConf = ModifiableHadoopConfiguration.of(TitanHadoopConfiguration.MAPRED_NS, hadoopConf);
        VertexScanJob vertexScan = this.getVertexScanJob(scanConf);
        ModifiableConfiguration graphConf = HadoopVertexScanMapper.getTitanConfiguration(context);
        TitanGraph graph = TitanFactory.open((BasicConfiguration)graphConf);
        this.job = VertexJobConverter.convert((TitanGraph)graph, (VertexScanJob)vertexScan);
        this.metrics = new HadoopContextScanMetrics((TaskInputOutputContext)context);
        this.finishSetup(scanConf, (Configuration)graphConf);
    }

    private VertexScanJob getVertexScanJob(ModifiableHadoopConfiguration conf) {
        String jobClass = (String)conf.get(TitanHadoopConfiguration.SCAN_JOB_CLASS, new String[0]);
        try {
            return (VertexScanJob)Class.forName(jobClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

