/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.serializer.KryoRegistrator;

public class TitanKryoRegistrator
implements KryoRegistrator {
    public void registerClasses(Kryo kryo) {
        kryo.register(Geoshape.class, (Serializer)new GeoShapeKryoSerializer());
    }

    public static class GeoShapeKryoSerializer
    extends Serializer<Geoshape> {
        public void write(Kryo kryo, Output output, Geoshape geoshape) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Geoshape.GeoshapeBinarySerializer.write((OutputStream)outputStream, (Geoshape)geoshape);
                byte[] bytes = outputStream.toByteArray();
                output.write(bytes.length);
                output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception writing geoshape");
            }
        }

        public Geoshape read(Kryo kryo, Input input, Class<Geoshape> aClass) {
            int length = input.read();
            assert (length > 0);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(input.readBytes(length));
            try {
                return Geoshape.GeoshapeBinarySerializer.read((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception reding geoshape");
            }
        }
    }
}

