/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.blueprints;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.CommonsConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraElementTraversal;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraVertexProperty;
import com.thinkaurelius.titan.graphdb.relations.CacheEdge;
import com.thinkaurelius.titan.graphdb.relations.CacheVertexProperty;
import com.thinkaurelius.titan.graphdb.relations.SimpleTitanProperty;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.relations.StandardVertexProperty;
import com.thinkaurelius.titan.graphdb.tinkerpop.TitanGraphVariables;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.system.EmptyVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.EdgeLabelVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.PropertyKeyVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.graphdb.vertices.CacheVertex;
import com.thinkaurelius.titan.graphdb.vertices.PreloadedVertex;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.engine.StandardTraversalEngine;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.TransactionTest;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedGraph;

public abstract class AbstractTitanGraphProvider
extends AbstractGraphProvider {
    private static final Set<Class> IMPLEMENTATION = new HashSet<Class>(){
        {
            this.add(StandardTitanGraph.class);
            this.add(StandardTitanTx.class);
            this.add(StandardVertex.class);
            this.add(CacheVertex.class);
            this.add(PreloadedVertex.class);
            this.add(EdgeLabelVertex.class);
            this.add(PropertyKeyVertex.class);
            this.add(VertexLabelVertex.class);
            this.add(TitanSchemaVertex.class);
            this.add(EmptyVertex.class);
            this.add(StandardEdge.class);
            this.add(CacheEdge.class);
            this.add(EdgeLabel.class);
            this.add(EdgeLabelVertex.class);
            this.add(StandardVertexProperty.class);
            this.add(CacheVertexProperty.class);
            this.add(SimpleTitanProperty.class);
            this.add(CacheVertexProperty.class);
            this.add(FulgoraVertexProperty.class);
            this.add(TitanGraphVariables.class);
            this.add(FulgoraElementTraversal.class);
        }
    };

    public Set<Class> getImplementations() {
        return IMPLEMENTATION;
    }

    public GraphTraversalSource traversal(Graph graph) {
        return GraphTraversalSource.standard().create(graph);
    }

    public GraphTraversalSource traversal(Graph graph, TraversalStrategy ... strategies) {
        GraphTraversalSource.Builder builder = GraphTraversalSource.build().engine((TraversalEngine.Builder)StandardTraversalEngine.build());
        Stream.of(strategies).forEach(arg_0 -> ((GraphTraversalSource.Builder)builder).with(arg_0));
        return builder.create(graph);
    }

    public void clear(Graph g, Configuration configuration) throws Exception {
        CommonsConfiguration config;
        BasicConfiguration readConfig;
        if (null != g) {
            while (g instanceof WrappedGraph) {
                g = (Graph)((WrappedGraph)g).getBaseGraph();
            }
            TitanGraph graph = (TitanGraph)g;
            if (graph.isOpen()) {
                if (g.tx().isOpen()) {
                    g.tx().rollback();
                }
                g.close();
            }
        }
        if ((readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)(config = new CommonsConfiguration(configuration)), BasicConfiguration.Restriction.NONE)).has(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0])) {
            TitanGraphBaseTest.clearGraph((WriteConfiguration)config);
        }
    }

    public Map<String, Object> getBaseConfiguration(String graphName, Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
        ModifiableConfiguration conf = this.getTitanConfiguration(graphName, test, testMethodName);
        conf.set(GraphDatabaseConfiguration.COMPUTER_RESULT_MODE, (Object)"persist", new String[0]);
        conf.set(GraphDatabaseConfiguration.AUTO_TYPE, (Object)"tp3", new String[0]);
        HashMap<String, Object> result = new HashMap<String, Object>();
        conf.getAll().entrySet().stream().forEach(e -> result.put(ConfigElement.getPath((ConfigElement)((ConfigElement.PathIdentifier)e.getKey()).element, (String[])((ConfigElement.PathIdentifier)e.getKey()).umbrellaElements), e.getValue()));
        result.put("gremlin.graph", TitanFactory.class.getName());
        return result;
    }

    public abstract ModifiableConfiguration getTitanConfiguration(String var1, Class<?> var2, String var3);

    public void loadGraphData(Graph g, LoadGraphWith loadGraphWith, Class testClass, String testName) {
        if (loadGraphWith != null) {
            this.createIndices((TitanGraph)g, loadGraphWith.value());
        } else if (TransactionTest.class.equals((Object)testClass) && testName.equalsIgnoreCase("shouldExecuteWithCompetingThreads")) {
            TitanManagement mgmt = ((TitanGraph)g).openManagement();
            mgmt.makePropertyKey("blah").dataType(Double.class).make();
            mgmt.makePropertyKey("bloop").dataType(Integer.class).make();
            mgmt.makePropertyKey("test").dataType(Object.class).make();
            mgmt.makeEdgeLabel("friend").make();
            mgmt.commit();
        }
        super.loadGraphData(g, loadGraphWith, testClass, testName);
    }

    private void createIndices(TitanGraph g, LoadGraphWith.GraphData graphData) {
        TitanManagement mgmt = g.openManagement();
        if (graphData.equals((Object)LoadGraphWith.GraphData.GRATEFUL)) {
            VertexLabel artist = mgmt.makeVertexLabel("artist").make();
            VertexLabel song = mgmt.makeVertexLabel("song").make();
            PropertyKey name = mgmt.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey songType = mgmt.makePropertyKey("songType").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey performances = mgmt.makePropertyKey("performances").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            mgmt.buildIndex("artistByName", Vertex.class).addKey(name).indexOnly((TitanSchemaType)artist).buildCompositeIndex();
            mgmt.buildIndex("songByName", Vertex.class).addKey(name).indexOnly((TitanSchemaType)song).buildCompositeIndex();
            mgmt.buildIndex("songByType", Vertex.class).addKey(songType).indexOnly((TitanSchemaType)song).buildCompositeIndex();
            mgmt.buildIndex("songByPerformances", Vertex.class).addKey(performances).indexOnly((TitanSchemaType)song).buildCompositeIndex();
        } else if (graphData.equals((Object)LoadGraphWith.GraphData.MODERN)) {
            VertexLabel person = mgmt.makeVertexLabel("person").make();
            VertexLabel software = mgmt.makeVertexLabel("software").make();
            PropertyKey name = mgmt.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey lang = mgmt.makePropertyKey("lang").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey age = mgmt.makePropertyKey("age").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            mgmt.buildIndex("personByName", Vertex.class).addKey(name).indexOnly((TitanSchemaType)person).buildCompositeIndex();
            mgmt.buildIndex("softwareByName", Vertex.class).addKey(name).indexOnly((TitanSchemaType)software).buildCompositeIndex();
            mgmt.buildIndex("personByAge", Vertex.class).addKey(age).indexOnly((TitanSchemaType)person).buildCompositeIndex();
            mgmt.buildIndex("softwareByLang", Vertex.class).addKey(lang).indexOnly((TitanSchemaType)software).buildCompositeIndex();
        } else if (graphData.equals((Object)LoadGraphWith.GraphData.CLASSIC)) {
            PropertyKey name = mgmt.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey lang = mgmt.makePropertyKey("lang").cardinality(Cardinality.LIST).dataType(String.class).make();
            PropertyKey age = mgmt.makePropertyKey("age").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            mgmt.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
            mgmt.buildIndex("byAge", Vertex.class).addKey(age).buildCompositeIndex();
            mgmt.buildIndex("byLang", Vertex.class).addKey(lang).buildCompositeIndex();
        }
        mgmt.commit();
    }
}

