/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardSerializer;
import com.thinkaurelius.titan.testutil.RandomGenerator;
import java.util.Arrays;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyValueStoreUtil.class);
    public static final Serializer serial = new StandardSerializer();
    public static final long idOffset = 1000L;
    public static final StaticBuffer MIN_KEY = BufferUtil.getLongBuffer((long)0L);
    public static final StaticBuffer MAX_KEY = BufferUtil.getLongBuffer((long)-1L);

    public static String[] generateData(int numKeys) {
        String[] ret = new String[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            ret[i] = RandomGenerator.randomString();
        }
        return ret;
    }

    public static String[][] generateData(int numKeys, int numColumns) {
        String[][] ret = new String[numKeys][numColumns];
        for (int i = 0; i < numKeys; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ret[i][j] = RandomGenerator.randomString();
            }
        }
        return ret;
    }

    public static void print(String[] data) {
        log.debug(Arrays.toString(data));
    }

    public static void print(String[][] data) {
        for (int i = 0; i < data.length; ++i) {
            KeyValueStoreUtil.print(data[i]);
        }
    }

    public static StaticBuffer getBuffer(int no) {
        return BufferUtil.getLongBuffer((long)((long)no + 1000L));
    }

    public static int getID(StaticBuffer b) {
        long res = b.getLong(0) - 1000L;
        Assert.assertTrue((res >= 0L && res < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)res;
    }

    public static StaticBuffer getBuffer(String s) {
        DataOutput out = serial.getDataOutput(50);
        out.writeObjectNotNull((Object)s);
        return out.getStaticBuffer();
    }

    public static String getString(ReadBuffer b) {
        return (String)serial.readObjectNotNull((ScanBuffer)b, String.class);
    }

    public static String getString(StaticBuffer b) {
        return (String)serial.readObjectNotNull((ScanBuffer)b.asReadBuffer(), String.class);
    }

    public static int count(RecordIterator<?> iterator) throws BackendException {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

