/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.AbstractKCVSTest;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.KeyColumnValueStoreUtil;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CacheTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVEntryMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.NoKCVSCache;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiWriteKeyColumnValueStoreTest
extends AbstractKCVSTest {
    private Logger log = LoggerFactory.getLogger(MultiWriteKeyColumnValueStoreTest.class);
    int numKeys = 500;
    int numColumns = 50;
    int bufferSize = 20;
    protected String storeName1 = "testStore1";
    private KCVSCache store1;
    protected String storeName2 = "testStore2";
    private KCVSCache store2;
    public KeyColumnValueStoreManager manager;
    public StoreTransaction tx;
    private Random rand = new Random(10L);

    @Before
    public void setUp() throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    @After
    public void tearDown() throws Exception {
        this.close();
    }

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void open() throws BackendException {
        this.manager = this.openStorageManager();
        this.tx = new CacheTransaction(this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig()), this.manager, this.bufferSize, Duration.ofMillis(100L), true);
        this.store1 = new NoKCVSCache(this.manager.openDatabase(this.storeName1));
        this.store2 = new NoKCVSCache(this.manager.openDatabase(this.storeName2));
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        if (null != this.store1) {
            this.store1.close();
        }
        if (null != this.store2) {
            this.store2.close();
        }
        if (null != this.manager) {
            this.manager.close();
        }
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    public void newTx() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = new CacheTransaction(this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig()), this.manager, this.bufferSize, Duration.ofMillis(100L), true);
    }

    @Test
    public void deletionsAppliedBeforeAdditions() throws BackendException {
        int i;
        StaticBuffer b1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        Assert.assertNull((Object)KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx));
        ArrayList additions = Lists.newArrayList((Object[])new Entry[]{StaticArrayEntry.of((StaticBuffer)b1, (StaticBuffer)b1)});
        ArrayList deletions = Lists.newArrayList((Iterable)additions);
        HashMap<StaticBuffer, KCVEntryMutation> combination = new HashMap<StaticBuffer, KCVEntryMutation>(1);
        HashMap<StaticBuffer, KCVEntryMutation> deleteOnly = new HashMap<StaticBuffer, KCVEntryMutation>(1);
        HashMap<StaticBuffer, KCVEntryMutation> addOnly = new HashMap<StaticBuffer, KCVEntryMutation>(1);
        combination.put(b1, new KCVEntryMutation((List)additions, (List)deletions));
        deleteOnly.put(b1, new KCVEntryMutation(KeyColumnValueStore.NO_ADDITIONS, (List)deletions));
        addOnly.put(b1, new KCVEntryMutation((List)additions, KCVSCache.NO_DELETIONS));
        this.store1.mutateEntries(b1, (List)additions, (List)deletions, this.tx);
        this.newTx();
        StaticBuffer result = KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx);
        Assert.assertEquals((Object)b1, (Object)result);
        this.store1.mutateEntries(b1, KeyColumnValueStore.NO_ADDITIONS, (List)deletions, this.tx);
        this.newTx();
        for (i = 0; i < 100; ++i) {
            StaticBuffer n = KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx);
            Assert.assertNull((Object)n);
            this.store1.mutateEntries(b1, (List)additions, KCVSCache.NO_DELETIONS, this.tx);
            this.newTx();
            this.store1.mutateEntries(b1, KeyColumnValueStore.NO_ADDITIONS, (List)deletions, this.tx);
            this.newTx();
            n = KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx);
            Assert.assertNull((Object)n);
        }
        for (i = 0; i < 100; ++i) {
            this.store1.mutateEntries(b1, KeyColumnValueStore.NO_ADDITIONS, (List)deletions, this.tx);
            this.newTx();
            this.store1.mutateEntries(b1, (List)additions, KCVSCache.NO_DELETIONS, this.tx);
            this.newTx();
            Assert.assertEquals((Object)b1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx));
        }
        for (i = 0; i < 100; ++i) {
            this.store1.mutateEntries(b1, (List)additions, (List)deletions, this.tx);
            this.newTx();
            Assert.assertEquals((Object)b1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx));
        }
    }

    @Test
    public void mutateManyWritesSameKeyOnMultipleCFs() throws BackendException {
        long arbitraryLong = 42L;
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(1764L);
        StaticBuffer val = KeyColumnValueStoreUtil.longToByteBuffer(74088L);
        StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer(42L);
        StaticBuffer nextCol = KeyColumnValueStoreUtil.longToByteBuffer(43L);
        StoreTransaction directTx = this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
        KCVMutation km = new KCVMutation((List)Lists.newArrayList((Object[])new Entry[]{StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val)}), (List)Lists.newArrayList());
        ImmutableMap keyColumnAndValue = ImmutableMap.of((Object)key, (Object)km);
        ImmutableMap mutations = ImmutableMap.of((Object)this.storeName1, (Object)keyColumnAndValue, (Object)this.storeName2, (Object)keyColumnAndValue);
        this.manager.mutateMany((Map)mutations, directTx);
        directTx.commit();
        KeySliceQuery query = new KeySliceQuery(key, col, nextCol);
        ImmutableList expected = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val));
        Assert.assertEquals((Object)expected, (Object)this.store1.getSlice(query, this.tx));
        Assert.assertEquals((Object)expected, (Object)this.store2.getSlice(query, this.tx));
    }

    @Test
    public void mutateManyStressTest() throws BackendException {
        HashMap<StaticBuffer, Map<StaticBuffer, StaticBuffer>> state = new HashMap<StaticBuffer, Map<StaticBuffer, StaticBuffer>>();
        int dels = 1024;
        int adds = 4096;
        for (int round = 0; round < 5; ++round) {
            Map<StaticBuffer, KCVEntryMutation> changes = this.mutateState(state, dels, adds);
            this.applyChanges(changes, this.store1, this.tx);
            this.applyChanges(changes, this.store2, this.tx);
            this.newTx();
            int deletesExpected = 0 == round ? 0 : dels;
            int stateSizeExpected = adds + (adds - dels) * round;
            Assert.assertEquals((long)stateSizeExpected, (long)this.checkThatStateExistsInStore(state, (KeyColumnValueStore)this.store1, round));
            Assert.assertEquals((long)deletesExpected, (long)this.checkThatDeletionsApplied(changes, (KeyColumnValueStore)this.store1, round));
            Assert.assertEquals((long)stateSizeExpected, (long)this.checkThatStateExistsInStore(state, (KeyColumnValueStore)this.store2, round));
            Assert.assertEquals((long)deletesExpected, (long)this.checkThatDeletionsApplied(changes, (KeyColumnValueStore)this.store2, round));
        }
    }

    public void applyChanges(Map<StaticBuffer, KCVEntryMutation> changes, KCVSCache store, StoreTransaction tx) throws BackendException {
        for (Map.Entry<StaticBuffer, KCVEntryMutation> change : changes.entrySet()) {
            store.mutateEntries(change.getKey(), change.getValue().getAdditions(), change.getValue().getDeletions(), tx);
        }
    }

    public int checkThatStateExistsInStore(Map<StaticBuffer, Map<StaticBuffer, StaticBuffer>> state, KeyColumnValueStore store, int round) throws BackendException {
        int checked = 0;
        for (StaticBuffer key : state.keySet()) {
            for (StaticBuffer col : state.get(key).keySet()) {
                StaticBuffer val = state.get(key).get(col);
                Assert.assertEquals((Object)val, (Object)KCVSUtil.get((KeyColumnValueStore)store, (StaticBuffer)key, (StaticBuffer)col, (StoreTransaction)this.tx));
                ++checked;
            }
        }
        this.log.debug("Checked existence of {} key-column-value triples on round {}", (Object)checked, (Object)round);
        return checked;
    }

    public int checkThatDeletionsApplied(Map<StaticBuffer, KCVEntryMutation> changes, KeyColumnValueStore store, int round) throws BackendException {
        int checked = 0;
        int skipped = 0;
        for (StaticBuffer key : changes.keySet()) {
            KCVEntryMutation m = changes.get(key);
            if (!m.hasDeletions()) continue;
            List deletions = m.getDeletions();
            List additions = m.getAdditions();
            for (Entry entry : deletions) {
                StaticBuffer col = entry.getColumn();
                if (null != additions && additions.contains(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col))) {
                    ++skipped;
                    continue;
                }
                Assert.assertNull((Object)KCVSUtil.get((KeyColumnValueStore)store, (StaticBuffer)key, (StaticBuffer)col, (StoreTransaction)this.tx));
                ++checked;
            }
        }
        this.log.debug("Checked absence of {} key-column-value deletions on round {} (skipped {})", new Object[]{checked, round, skipped});
        return checked;
    }

    public Map<StaticBuffer, KCVEntryMutation> mutateState(Map<StaticBuffer, Map<StaticBuffer, StaticBuffer>> state, int maxDeletionCount, int additionCount) {
        int keyLength = 8;
        int colLength = 16;
        HashMap<StaticBuffer, KCVEntryMutation> result = new HashMap<StaticBuffer, KCVEntryMutation>();
        int dels = 0;
        StaticBuffer key = null;
        StaticArrayBuffer col = null;
        Entry entry = null;
        Iterator<StaticBuffer> keyIter = state.keySet().iterator();
        while (keyIter.hasNext() && dels < maxDeletionCount) {
            key = keyIter.next();
            Iterator<Map.Entry<StaticBuffer, StaticBuffer>> colIter = state.get(key).entrySet().iterator();
            while (colIter.hasNext() && dels < maxDeletionCount) {
                Map.Entry<StaticBuffer, StaticBuffer> colEntry = colIter.next();
                entry = StaticArrayEntry.of((StaticBuffer)colEntry.getKey(), (StaticBuffer)colEntry.getValue());
                if (!result.containsKey(key)) {
                    KCVEntryMutation m = new KCVEntryMutation(new LinkedList(), new LinkedList());
                    result.put(key, m);
                }
                ((KCVEntryMutation)result.get(key)).deletion((Object)entry);
                ++dels;
                colIter.remove();
                if (!state.get(key).isEmpty()) continue;
                assert (!colIter.hasNext());
                keyIter.remove();
            }
        }
        for (int i = 0; i < additionCount; ++i) {
            KCVEntryMutation m;
            do {
                byte[] keyBuf = new byte[8];
                this.rand.nextBytes(keyBuf);
                key = new StaticArrayBuffer(keyBuf);
                byte[] colBuf = new byte[16];
                this.rand.nextBytes(colBuf);
                col = new StaticArrayBuffer(colBuf);
            } while (state.containsKey(key) && state.get(key).containsKey(col));
            if (!state.containsKey(key)) {
                m = new HashMap();
                state.put(key, (Map<StaticBuffer, StaticBuffer>)m);
            }
            state.get(key).put((StaticBuffer)col, (StaticBuffer)col);
            if (!result.containsKey(key)) {
                m = new KCVEntryMutation(new LinkedList(), new LinkedList());
                result.put(key, m);
            }
            ((KCVEntryMutation)result.get(key)).addition((Object)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col));
        }
        return result;
    }

    public Map<StaticBuffer, KCVMutation> generateMutation(int keyCount, int columnCount, Map<StaticBuffer, KCVMutation> deleteFrom) {
        HashMap<StaticBuffer, KCVMutation> result = new HashMap<StaticBuffer, KCVMutation>(keyCount);
        Random keyRand = new Random(keyCount);
        Random colRand = new Random(columnCount);
        int keyLength = 8;
        int colLength = 6;
        Iterator<Map.Entry<StaticBuffer, KCVMutation>> deleteIter = null;
        List lastDeleteIterResult = null;
        if (null != deleteFrom) {
            deleteIter = deleteFrom.entrySet().iterator();
        }
        for (int ik = 0; ik < keyCount; ++ik) {
            byte[] keyBuf = new byte[8];
            keyRand.nextBytes(keyBuf);
            StaticArrayBuffer key = new StaticArrayBuffer(keyBuf);
            LinkedList<Entry> additions = new LinkedList<Entry>();
            LinkedList<StaticBuffer> deletions = new LinkedList<StaticBuffer>();
            for (int ic = 0; ic < columnCount; ++ic) {
                boolean deleteSucceeded = false;
                if (null != deleteIter && 1 == ic % 2) {
                    if (null == lastDeleteIterResult || lastDeleteIterResult.isEmpty()) {
                        while (deleteIter.hasNext()) {
                            Map.Entry<StaticBuffer, KCVMutation> ent = deleteIter.next();
                            if (!ent.getValue().hasAdditions() || ent.getValue().getAdditions().isEmpty()) continue;
                            lastDeleteIterResult = ent.getValue().getAdditions();
                            break;
                        }
                    }
                    if (null != lastDeleteIterResult && !lastDeleteIterResult.isEmpty()) {
                        Entry e = (Entry)lastDeleteIterResult.get(0);
                        lastDeleteIterResult.remove(0);
                        deletions.add(e.getColumn());
                        deleteSucceeded = true;
                    }
                }
                if (deleteSucceeded) continue;
                byte[] colBuf = new byte[6];
                colRand.nextBytes(colBuf);
                StaticArrayBuffer col = new StaticArrayBuffer(colBuf);
                additions.add(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col));
            }
            KCVMutation m = new KCVMutation(additions, deletions);
            result.put((StaticBuffer)key, m);
        }
        return result;
    }
}

