/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cache;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CacheTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory.InMemoryStoreManager;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProviders;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class KCVSCacheTest {
    public static final String STORE_NAME = "store";
    public static final TimestampProvider times = TimestampProviders.MICRO;
    public static final Duration MAX_WRITE_TIME = Duration.ofMillis(100L);
    public KeyColumnValueStoreManager storeManager;
    public CounterKCVS store;
    public KCVSCache cache;

    @Before
    public void setup() throws Exception {
        this.storeManager = new InMemoryStoreManager();
        this.store = new CounterKCVS(this.storeManager.openDatabase(STORE_NAME));
        this.cache = this.getCache(this.store);
    }

    public abstract KCVSCache getCache(KeyColumnValueStore var1);

    public StoreTransaction getStoreTx() {
        try {
            return this.storeManager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)times));
        }
        catch (BackendException se) {
            throw new RuntimeException(se);
        }
    }

    public CacheTransaction getCacheTx() {
        CacheTransaction cacheTx = new CacheTransaction(this.getStoreTx(), this.storeManager, 1024, MAX_WRITE_TIME, false);
        return cacheTx;
    }

    @After
    public void shutdown() throws Exception {
        this.cache.close();
        this.storeManager.close();
    }

    public void loadStore(int numKeys, int numCols) {
        StoreTransaction tx = this.getStoreTx();
        try {
            for (int i = 1; i <= numKeys; ++i) {
                ArrayList<Entry> adds = new ArrayList<Entry>(numCols);
                for (int j = 1; j <= numCols; ++j) {
                    adds.add(KCVSCacheTest.getEntry(j, j));
                }
                this.store.mutate(BufferUtil.getIntBuffer((int)i), adds, KeyColumnValueStore.NO_DELETIONS, tx);
            }
            tx.commit();
        }
        catch (BackendException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSmallCache() throws Exception {
        Map result;
        int numKeys = 100;
        int numCols = 10;
        int repeats = 100;
        int clearEvery = 20;
        int numMulti = 10;
        Assert.assertTrue((boolean)true);
        this.loadStore(100, 10);
        int calls = 0;
        Assert.assertEquals((long)calls, (long)this.store.getSliceCalls());
        for (int t = 0; t < 100; ++t) {
            if (t % 20 == 0) {
                this.cache.clearCache();
                calls += 201;
            }
            CacheTransaction tx = this.getCacheTx();
            for (int i = 1; i <= 100; ++i) {
                Assert.assertEquals((long)10L, (long)this.cache.getSlice(KCVSCacheTest.getQuery(i, 0, 11).setLimit(10), (StoreTransaction)tx).size());
                Assert.assertEquals((long)3L, (long)this.cache.getSlice(KCVSCacheTest.getQuery(i, 2, 5), (StoreTransaction)tx).size());
            }
            ArrayList<StaticBuffer> keys = new ArrayList<StaticBuffer>();
            for (int i = 10; i < 20; ++i) {
                keys.add(BufferUtil.getIntBuffer((int)i));
            }
            result = this.cache.getSlice(keys, KCVSCacheTest.getQuery(4, 9), (StoreTransaction)tx);
            Assert.assertEquals((long)keys.size(), (long)result.size());
            for (StaticBuffer key : keys) {
                Assert.assertTrue((boolean)result.containsKey(key));
            }
            for (EntryList r : result.values()) {
                Assert.assertEquals((long)5L, (long)r.size());
            }
            tx.commit();
            Assert.assertEquals((long)calls, (long)this.store.getSliceCalls());
        }
        this.store.resetCounter();
        StaticBuffer key = BufferUtil.getIntBuffer((int)23);
        ArrayList<StaticBuffer> keys = new ArrayList<StaticBuffer>();
        keys.add(key);
        keys.add(BufferUtil.getIntBuffer((int)12));
        keys.add(BufferUtil.getIntBuffer((int)5));
        CacheTransaction tx = this.getCacheTx();
        Assert.assertEquals((long)10L, (long)this.cache.getSlice(new KeySliceQuery(key, KCVSCacheTest.getQuery(0, 11)), (StoreTransaction)tx).size());
        result = this.cache.getSlice(keys, KCVSCacheTest.getQuery(2, 8), (StoreTransaction)tx);
        Assert.assertEquals((long)keys.size(), (long)result.size());
        Assert.assertEquals((long)6L, (long)((EntryList)result.get(key)).size());
        ArrayList<Entry> dels = new ArrayList<Entry>(5);
        for (int j = 1; j <= 10; j += 2) {
            dels.add(KCVSCacheTest.getEntry(j, j));
        }
        this.cache.mutateEntries(key, KeyColumnValueStore.NO_ADDITIONS, dels, (StoreTransaction)tx);
        tx.commit();
        Assert.assertEquals((long)2L, (long)this.store.getSliceCalls());
        tx = this.getCacheTx();
        Assert.assertEquals((long)5L, (long)this.cache.getSlice(new KeySliceQuery(key, KCVSCacheTest.getQuery(0, 11)), (StoreTransaction)tx).size());
        result = this.cache.getSlice(keys, KCVSCacheTest.getQuery(2, 8), (StoreTransaction)tx);
        Assert.assertEquals((long)keys.size(), (long)result.size());
        Assert.assertEquals((long)3L, (long)((EntryList)result.get(key)).size());
        tx.commit();
        Assert.assertEquals((long)4L, (long)this.store.getSliceCalls());
    }

    public static KeySliceQuery getQuery(int key, int startCol, int endCol) {
        return new KeySliceQuery(BufferUtil.getIntBuffer((int)key), KCVSCacheTest.getQuery(startCol, endCol));
    }

    public static SliceQuery getQuery(int startCol, int endCol) {
        return new SliceQuery(BufferUtil.getIntBuffer((int)startCol), BufferUtil.getIntBuffer((int)endCol));
    }

    public static Entry getEntry(int col, int val) {
        return new StaticArrayEntry(new WriteByteBuffer(8).putInt(col).putInt(val).getStaticBuffer(), 4);
    }

    public static class CounterKCVS
    implements KeyColumnValueStore {
        private final KeyColumnValueStore store;
        private final AtomicLong getSliceCounter;

        public CounterKCVS(KeyColumnValueStore store) {
            this.store = store;
            this.getSliceCounter = new AtomicLong(0L);
        }

        public long getSliceCalls() {
            return this.getSliceCounter.get();
        }

        public void resetCounter() {
            this.getSliceCounter.set(0L);
        }

        public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
            this.getSliceCounter.incrementAndGet();
            return this.store.getSlice(query, txh);
        }

        public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
            this.getSliceCounter.incrementAndGet();
            return this.store.getSlice(keys, query, txh);
        }

        public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
            this.store.mutate(key, additions, deletions, txh);
        }

        public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
            this.store.acquireLock(key, column, expectedValue, txh);
        }

        public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
            return this.store.getKeys(query, txh);
        }

        public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
            return this.store.getKeys(query, txh);
        }

        public String getName() {
            return this.store.getName();
        }

        public void close() throws BackendException {
            this.store.close();
        }
    }
}

