/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import java.time.Duration;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class WritableConfigurationTest {
    private WriteConfiguration config;

    public abstract WriteConfiguration getConfig();

    @Before
    public void setup() {
        this.config = this.getConfig();
    }

    @After
    public void cleanup() {
        this.config.close();
    }

    @Test
    public void configTest() {
        this.config.set("test.key", (Object)"world");
        this.config.set("test.bar", (Object)100);
        this.config.set("storage.xyz", (Object)true);
        this.config.set("storage.abc", (Object)Boolean.FALSE);
        this.config.set("storage.duba", (Object)new String[]{"x", "y"});
        this.config.set("times.60m", (Object)Duration.ofMinutes(60L));
        this.config.set("obj", new Object());
        Assert.assertEquals((Object)"world", (Object)this.config.get("test.key", String.class));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test.key", (Object)"test.bar"), (Object)Sets.newHashSet((Iterable)this.config.getKeys("test")));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"storage.xyz", (Object)"storage.duba", (Object)"storage.abc"), (Object)Sets.newHashSet((Iterable)this.config.getKeys("storage")));
        Assert.assertEquals((long)100L, (long)((Integer)this.config.get("test.bar", Integer.class)).intValue());
        Assert.assertEquals((Object)true, (Object)((Boolean)this.config.get("storage.xyz", Boolean.class)));
        Assert.assertEquals((Object)false, (Object)((Boolean)this.config.get("storage.abc", Boolean.class)));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"x", "y"}, (Object[])this.config.get("storage.duba", String[].class)));
        Assert.assertEquals((Object)Duration.ofMinutes(60L), (Object)this.config.get("times.60m", Duration.class));
        Assert.assertTrue((boolean)Object.class.isAssignableFrom(this.config.get("obj", Object.class).getClass()));
    }
}

