/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.StandardIndexProvider;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import java.util.List;
import java.util.Map;

public class TestMockIndexProvider
implements IndexProvider {
    public static final ConfigOption<Boolean> INDEX_MOCK_FAILADD = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "fail-adds", "Sets the index provider to reject adding documents. FOR TESTING ONLY", ConfigOption.Type.LOCAL, (Object)false).hide();
    public static final ConfigOption<String> INDEX_BACKEND_PROXY = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "proxy-for", "Define the indexing backed to use for index support behind the mock proxy", ConfigOption.Type.GLOBAL, GraphDatabaseConfiguration.INDEX_BACKEND.getDefaultValue()).hide();
    private final IndexProvider index;
    private final boolean failAdds;

    public TestMockIndexProvider(Configuration config) {
        this.index = (IndexProvider)Backend.getImplementationClass((Configuration)config, (String)((String)config.get(INDEX_BACKEND_PROXY, new String[0])), (Map)StandardIndexProvider.getAllProviderClasses());
        this.failAdds = (Boolean)config.get(INDEX_MOCK_FAILADD, new String[0]);
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        this.index.register(store, key, information, tx);
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        if (this.failAdds) {
            throw new TemporaryBackendException("Blocked mutation");
        }
        this.index.mutate(mutations, informations, tx);
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        if (this.failAdds) {
            throw new TemporaryBackendException("Blocked mutation");
        }
        this.index.restore(documents, informations, tx);
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        return this.index.query(query, informations, tx);
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        return this.index.query(query, informations, tx);
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return this.index.beginTransaction(config);
    }

    public void close() throws BackendException {
        this.index.close();
    }

    public void clearStorage() throws BackendException {
        this.index.clearStorage();
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        return this.index.supports(information, titanPredicate);
    }

    public boolean supports(KeyInformation information) {
        return this.index.supports(information);
    }

    public String mapKey2Field(String key, KeyInformation information) {
        return this.index.mapKey2Field(key, information);
    }

    public IndexFeatures getFeatures() {
        return this.index.getFeatures();
    }
}

